/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.statemachine;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.service.AbstractSyncTrigger;
import org.eclipse.papyrus.infra.sync.service.ISyncAction;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.statemachine.CSMDStateMachineSyncBucket;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.statemachine.CSMDStateMachineSyncRegistry;
import org.eclipse.uml2.uml.StateMachine;

public class CapsuleStatemachineDiagramSyncTrigger
extends AbstractSyncTrigger {
    public ISyncAction trigger(ISyncService syncService, Object object) {
        EditPart stateMachine;
        ISyncAction result = null;
        if (object instanceof DiagramEditPart && (stateMachine = ((DiagramEditPart)object).getPrimaryChildEditPart()) != null) {
            result = this.synchronizeStateMachineAction();
        }
        return result;
    }

    protected ISyncAction synchronizeStateMachineAction() {
        return new ISyncAction(){

            public IStatus perform(ISyncService syncService, Object object) {
                IStatus result = Status.OK_STATUS;
                EditPart stateMachineFrame = ((DiagramEditPart)object).getPrimaryChildEditPart();
                StateMachine stateMachine = (StateMachine)AdapterUtils.adapt((Object)stateMachineFrame, StateMachine.class, null);
                if (stateMachine == null) {
                    result = new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.diagram.common", "Edit-part does not visualize a StateMachine");
                } else {
                    CSMDStateMachineSyncRegistry registry = (CSMDStateMachineSyncRegistry)syncService.getSyncRegistry(CSMDStateMachineSyncRegistry.class);
                    if (registry != null) {
                        SyncBucket masterBucket;
                        StateMachine master;
                        Object bucket = registry.getBucket(stateMachine);
                        if (bucket == null) {
                            bucket = new CSMDStateMachineSyncBucket(stateMachine, stateMachineFrame);
                            registry.register(bucket);
                        }
                        if ((master = registry.getRedefinedElement(stateMachine)) != null && (masterBucket = registry.getBucket(master)) != null) {
                            masterBucket.add((Object)stateMachineFrame);
                        }
                    }
                }
                return result;
            }
        };
    }
}

