/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.figure.node.SubCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;

public class RTPortPositionLocator
extends PortPositionLocator {
    private final Element port;
    private final double scaleFactor;

    public RTPortPositionLocator(Element droppedElement, IFigure parentFigure, int preferredSide) {
        this(droppedElement, parentFigure, preferredSide, 1.0);
    }

    public RTPortPositionLocator(Element droppedElement, IFigure parentFigure, int preferredSide, double scaleFactor) {
        super(parentFigure, preferredSide);
        this.port = droppedElement;
        this.scaleFactor = scaleFactor;
        if (scaleFactor != 1.0) {
            this.setBorderItemOffset((int)Math.ceil((double)this.getBorderItemOffset() * scaleFactor));
        }
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle newLocation = null;
        if (this.port instanceof Port) {
            RTPortKindEnum kind = RTPortUtils.getKind((Port)((Port)this.port));
            if (kind != null) {
                switch (kind) {
                    case EXTERNAL: 
                    case RELAY: 
                    case SPP: {
                        newLocation = this.getPreferredBorderedLocation(proposedLocation);
                        break;
                    }
                    case INTERNAL: 
                    case SAP: {
                        newLocation = this.getPreferredInternalLocation(proposedLocation);
                        break;
                    }
                    default: {
                        newLocation = this.getPreferredBorderedLocation(proposedLocation);
                        break;
                    }
                }
            } else {
                newLocation = this.getPreferredBorderedLocation(proposedLocation);
            }
        } else {
            newLocation = this.getPreferredBorderedLocation(proposedLocation);
        }
        return newLocation;
    }

    private Rectangle getPreferredInternalLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        IFigure compartment = this.getCompositeCompartmentFigure(this.parentFigure);
        if (compartment != null) {
            Rectangle compartmentBounds = compartment.getBounds().getCopy();
            int xMin = compartmentBounds.x + this.borderItemOffset;
            int xMax = compartmentBounds.x + compartmentBounds.width - this.borderItemOffset - realLocation.width;
            int yMin = compartmentBounds.y + this.borderItemOffset;
            int yMax = compartmentBounds.y + compartmentBounds.height - this.borderItemOffset - realLocation.height;
            if (realLocation.x < xMin) {
                realLocation.x = xMin;
            }
            if (realLocation.x > xMax) {
                realLocation.x = xMax;
            }
            if (realLocation.y < yMin) {
                realLocation.y = yMin;
            }
            if (realLocation.y > yMax) {
                realLocation.y = yMax;
            }
        }
        return realLocation;
    }

    private IFigure getCompositeCompartmentFigure(IFigure parentFigure) {
        IFigure composite = null;
        Iterator childrenIterator = parentFigure.getChildren().iterator();
        while (composite == null && childrenIterator.hasNext()) {
            Object child = childrenIterator.next();
            if (!(child instanceof IFigure)) continue;
            if (((IFigure)child).getLayoutManager() instanceof SubCompartmentLayoutManager) {
                composite = (IFigure)child;
            }
            if (composite != null) continue;
            composite = this.getCompositeCompartmentFigure((IFigure)child);
        }
        return composite;
    }

    private Rectangle getPreferredBorderedLocation(Rectangle proposedLocation) {
        return super.getPreferredLocation(proposedLocation);
    }

    public void setConstraint(Rectangle constraint) {
        if (this.scaleFactor != 1.0 && constraint.getSize().equals(-1, -1)) {
            int size = (int)Math.ceil(20.0 * this.scaleFactor);
            constraint.setSize(size, size);
        }
        super.setConstraint(constraint);
    }
}

