/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.service;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.NotationFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Vertex;

public class UMLRTNotationFilteredLabelProvider
extends NotationFilteredLabelProvider {
    protected String getText(EObject element) {
        String result = super.getText(element);
        if (element instanceof Diagram) {
            Diagram diagram = (Diagram)element;
            EObject context = diagram.getElement();
            if (context != null) {
                result = super.getText(context);
            }
            BehavioredClassifier behaviorContext = null;
            if (context instanceof Behavior) {
                behaviorContext = ((Behavior)context).getContext();
            } else if (context instanceof Vertex) {
                behaviorContext = ((Vertex)context).containingStateMachine().getContext();
            }
            if (behaviorContext != null) {
                super.getText((EObject)behaviorContext);
            }
            if (UMLRTCapsuleStructureDiagramUtils.isCapsuleStructureDiagram(diagram)) {
                result = UMLRTCapsuleStructureDiagramUtils.getDisplayedCapsuleStructureDiagramName(diagram);
                this.subscribe(context, (EObject)diagram);
            } else if (UMLRTStateMachineDiagramUtils.isRTStateMachineDiagram(diagram)) {
                result = UMLRTStateMachineDiagramUtils.getDisplayedDiagramName(diagram);
                this.subscribe(context, (EObject)diagram);
                if (behaviorContext != null) {
                    this.subscribe((EObject)behaviorContext, (EObject)diagram);
                }
            } else {
                result = diagram.getName();
                this.unsubscribe(context, (EObject)diagram);
                if (behaviorContext != null) {
                    this.unsubscribe((EObject)behaviorContext, (EObject)diagram);
                }
            }
        }
        return result;
    }
}

