/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UMLRTEditPartUtils {
    private static final AtomicReference<Runnable> pendingDirectEditRequest = new AtomicReference();

    private UMLRTEditPartUtils() {
    }

    public static void scheduleDirectEdit(final EditPartViewer viewer, Supplier<? extends EditPart> onEditPart) {
        DiagramHelper.asyncExec((EditPart)viewer.getRootEditPart(), () -> {
            Runnable inlineEdit;
            final EditPart toEdit = (EditPart)onEditPart.get();
            if (toEdit != null && toEdit.isActive() && pendingDirectEditRequest.compareAndSet(null, inlineEdit = new Runnable(){

                @Override
                public void run() {
                    pendingDirectEditRequest.compareAndSet(this, null);
                    if (toEdit.isActive()) {
                        toEdit.performRequest(new Request((Object)"direct edit"));
                        viewer.reveal(toEdit);
                    }
                }
            })) {
                UMLRTEditPartUtils.ensureWorkbenchPartActive(viewer);
                viewer.setSelection((ISelection)new StructuredSelection((Object)toEdit));
                viewer.getControl().getDisplay().asyncExec(inlineEdit);
            }
        });
    }

    public static void scheduleDirectEdit(EditPart ancestor, EObject element) {
        EditPartViewer viewer;
        IGraphicalEditPart graphicalAncestor;
        if (pendingDirectEditRequest.get() == null && (graphicalAncestor = (IGraphicalEditPart)TypeUtils.as((Object)ancestor, IGraphicalEditPart.class)) != null && (viewer = graphicalAncestor.getViewer()) != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            UMLRTEditPartUtils.scheduleDirectEdit(viewer, () -> graphicalAncestor.isActive() ? graphicalAncestor.findEditPart((EditPart)graphicalAncestor, element) : null);
        }
    }

    private static void ensureWorkbenchPartActive(EditPartViewer viewer) {
        Optional.ofNullable(PlatformUI.getWorkbench()).map(IWorkbench::getActiveWorkbenchWindow).map(IWorkbenchWindow::getActivePage).ifPresent(page -> {
            IEditorPart editor = page.getActiveEditor();
            if (editor != null && editor.getAdapter(GraphicalViewer.class) == viewer) {
                page.activate((IWorkbenchPart)editor);
            }
        });
    }

    public static Optional<IGraphicalEditPart> getChild(IGraphicalEditPart parentEditPart, EObject element) {
        List children = parentEditPart.getChildren();
        return children.stream().filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).filter(child -> child.resolveSemanticElement() == element).findFirst();
    }

    public static Optional<IGraphicalEditPart> findChildAt(IGraphicalEditPart parentEditPart, Point location) {
        location = location.getTranslated(parentEditPart.getFigure().getBounds().getLocation());
        parentEditPart.getFigure().translateToAbsolute((Translatable)location);
        EditPart result = parentEditPart.getViewer().findObjectAtExcluding(location, Collections.emptySet(), ep -> ep.getParent() == parentEditPart);
        return Optional.ofNullable(result).filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast);
    }
}

