package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	/** Registry key of the composite-state decorator (overlay) asset. */
	public static final String IMG_OVR_COMPOSITE_STATE = "ovr_composite_state"; //$NON-NLS-1$

	/** Local path of the composite-state decorator (overlay) asset. */
	private static final String PATH_OVR_COMPOSITE_STATE = "$nl$/icons/full/ovr32/composite_state_ovr.png"; //$NON-NLS-1$

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;

	/**
	 * The constructor
	 */
	public Activator() {
		super();
	}

	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * Obtains a registered image from my {@linkplain #getImageRegistry() registry}.
	 * 
	 * @param key
	 *            the image key
	 * 
	 * @return the image
	 */
	public static Image getImage(String key) {
		return getDefault().getImageRegistry().get(key);
	}

	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		super.initializeImageRegistry(reg);

		reg.put(IMG_OVR_COMPOSITE_STATE, imageDescriptorFromPlugin(PLUGIN_ID, PATH_OVR_COMPOSITE_STATE));
	}
}
