/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.canonical;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.BasicDecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.canonical.DefaultUMLSemanticChildrenStrategy;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPart;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;

/**
 * Canonical edit-policy specializations for RT state machine diagrams.
 */
public class RTStateMachineSemanticChildrenStrategy extends DefaultUMLSemanticChildrenStrategy {

	/**
	 * Initializes me.
	 */
	public RTStateMachineSemanticChildrenStrategy() {
		super();
	}

	@Override
	public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
		List<? extends EObject> result = super.getCanonicalSemanticChildren(semanticFromEditPart, viewFromEditPart);

		if (result != null) {
			if (isStateInRegion(viewFromEditPart)) {
				// Don't show the regions of a composite state (only connection points)
				result.removeIf(Region.class::isInstance);
			} else if ((semanticFromEditPart instanceof State) || (semanticFromEditPart instanceof Region)) {
				if (viewFromEditPart instanceof BasicDecorationNode) {
					// Don't show connection-point pseudostates in a compartment
					result.removeIf(this::isConnectionPoint);
				}
			}
		}

		return result;
	}

	protected boolean isStateInRegion(View notationView) {
		boolean result = false;

		// Look for shape containing the compartment, if a compartment
		while ((notationView instanceof BasicDecorationNode) && (notationView.eContainer() instanceof View)) {
			notationView = (View) notationView.eContainer();
		}

		// Is it a state?
		if (StateEditPart.VISUAL_ID.equals(notationView.getType())) {
			// In a compartment?
			result = notationView.eContainer() instanceof BasicDecorationNode;
		}

		return result;
	}

	protected boolean isConnectionPoint(EObject object) {
		boolean result = false;

		if (object instanceof Pseudostate) {
			switch (((Pseudostate) object).getKind()) {
			case ENTRY_POINT_LITERAL:
			case EXIT_POINT_LITERAL:
				result = true;
				break;
			default:
				result = false;
				break;
			}
		}

		return result;
	}
}
