/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.provider;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.CallEventUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.InterfaceRealizationUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UsageUtils;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.provider.UMLRTLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.utils.LabelUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Usage;

public class UMLRTFilteredLabelProvider
extends UMLRTLabelProvider
implements IFilteredLabelProvider {
    public boolean accept(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (this.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean accept(Object element) {
        if (element instanceof IStructuredSelection) {
            return this.accept((IStructuredSelection)element);
        }
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            return false;
        }
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType)) continue;
            IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
            if (matcher != null) {
                if (!matcher.matches(semanticObject)) continue;
                return true;
            }
            Activator.log.debug("no matcher for this element type: " + type);
        }
        if (semanticObject instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof Interface && MessageSetUtils.isRTMessageSet((Element)((Interface)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof InterfaceRealization && InterfaceRealizationUtils.isInterfaceRealizationFromProtocol((InterfaceRealization)((InterfaceRealization)semanticObject))) {
            return true;
        }
        return semanticObject instanceof Usage && UsageUtils.isUsageFromProtocol((Usage)((Usage)semanticObject));
    }

    @Override
    public Image getImage(EObject element) {
        if (!(element instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(element);
        if (matchingTypeMatcher == null) {
            if (element instanceof Element) {
                return this.baseEMFLabelProvider.getImage((Object)element);
            }
            return null;
        }
        return super.getImage(element);
    }

    @Override
    public String getText(EObject element) {
        ISpecializationType inMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
        if (inMessageType != null && inMessageType.getMatcher() != null && inMessageType.getMatcher().matches(element)) {
            return "in " + super.getText(element);
        }
        ISpecializationType outMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
        if (outMessageType != null && outMessageType.getMatcher() != null && outMessageType.getMatcher().matches(element)) {
            return "out " + super.getText(element);
        }
        ISpecializationType inOutMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
        if (inOutMessageType != null && inOutMessageType.getMatcher() != null && inOutMessageType.getMatcher().matches(element)) {
            return "inout " + super.getText(element);
        }
        if (element instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)element))) {
            return LabelUtils.getCallEventForProtocolMessageLabel((CallEvent)element, labelProvider);
        }
        if (element instanceof Package && ProtocolContainerUtils.isProtocolContainer((EObject)element)) {
            return LabelUtils.getProtocolContainerLabel((Package)element, labelProvider);
        }
        if (element instanceof Interface && MessageSetUtils.isRTMessageSet((Element)((Interface)element))) {
            return LabelUtils.getMessageSetLabel((Interface)element, labelProvider);
        }
        if (element instanceof InterfaceRealization && InterfaceRealizationUtils.isInterfaceRealizationFromProtocol((InterfaceRealization)((InterfaceRealization)element))) {
            return LabelUtils.getInterfaceRealizationLabel((InterfaceRealization)element, labelProvider);
        }
        if (element instanceof Usage && UsageUtils.isUsageFromProtocol((Usage)((Usage)element))) {
            return LabelUtils.getUsageLabel((Usage)element, labelProvider);
        }
        return super.getText(element);
    }
}

