/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Celine Janssens (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.properties.widget;

import java.util.List;

import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.editors.ParameterControlEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;

/**
 * Button Control Widget for the Parameter of a Protocol Message
 * 
 * @author Céline JANSSENS
 *
 * @see ParameterControlEditor
 * @see OwnedParameterOperationPropertyEditor
 */
public class ParameterControlWidget extends AbstractPropertyEditor {

	/**
	 * Editor with the Control Buttons
	 */
	protected ParameterControlEditor editor;

	/**
	 * 
	 * Constructor.
	 *
	 * @param parent
	 *            The Parent Composite
	 * @param style
	 *            The Style
	 * @param operation
	 *            The Related Operation on which the parameter is added
	 * @param nattableManager
	 *            The Table Manager of the Parameter Table
	 */
	public ParameterControlWidget(final Composite parent, final int style, final Operation operation, final INattableModelManager nattableManager) {

		editor = new ParameterControlEditor(parent, style, operation, nattableManager);
		super.setEditor(editor);
	}

	/**
	 * Setter of parameter in the Editor
	 * 
	 * @param selectedParameter
	 *            the parameter which the editor is editing
	 */
	public void setParameter(final Parameter selectedParameter) {
		editor.setSelectedParameter(selectedParameter);

	}

	/**
	 * Setter of a list of parameters in the Editor
	 * 
	 * @param selectedParameterList
	 *            the list of parameters which the editor is editing
	 */
	public void setParameters(final List<Parameter> selectedParameterList) {
		editor.setSelectedParameters(selectedParameterList);

	}

}
