/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.tables.editors.cell;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.commands.InteractiveSetTypedElementTypeCommand;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.TypedElement;

public class ParameterTypeCellEditor
extends AbstractDialogCellEditor {
    private INattableModelManager manager;
    private Object axisElement;

    public ParameterTypeCellEditor(Object axisElement, ITableAxisElementProvider elementProvider) {
        this.manager = (INattableModelManager)elementProvider;
        this.axisElement = axisElement;
    }

    public Object createDialogInstance() {
        int columnIndex = this.layerCell.getColumnIndex();
        int rowIndex = this.layerCell.getRowIndex();
        Object row = this.manager.getRowElement(rowIndex);
        Object column = this.manager.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Parameter parameter = row instanceof Parameter && column == this.axisElement ? (Parameter)row : (Parameter)column;
        this.dialog = new InteractiveSetTypedElementTypeCommand((TypedElement)parameter, (IElementType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_PARAMETER, (IElementType)UMLElementTypes.CLASSIFIER, type -> type == UMLElementTypes.CLASSIFIER ? "Type" : type.getEClass().getName());
        ((InteractiveSetTypedElementTypeCommand)this.dialog).setNewTypeViews(this.getNewTypeDialogViews());
        return this.dialog;
    }

    private Collection<? extends View> getNewTypeDialogViews() {
        Optional<EStructuralFeatureAxis> axis = AxisUtils.getAxisProviderUsedForColumns((INattableModelManager)this.manager).getAxis().stream().filter(EStructuralFeatureAxis.class::isInstance).map(EStructuralFeatureAxis.class::cast).filter(a -> a.getElement() == this.axisElement).findFirst();
        Optional<EAnnotation> annotation = axis.map(a -> a.getEAnnotation("http://www.eclipse.org/papyrusrt/tables/1.0.0/creation/dialogViews"));
        return annotation.map(a -> a.getReferences().stream().filter(View.class::isInstance).map(View.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public Object getDialogInstance() {
        return this.dialog;
    }

    public void setEditorValue(Object value) {
    }

    public int open() {
        if (this.dialog instanceof ICommand) {
            try {
                TransactionalEditingDomain domain = TableEditingDomainUtils.getTableContextEditingDomain((Table)this.manager.getTable());
                domain.getCommandStack().execute((Command)ICommandWrapper.wrap((Object)this.dialog, Command.class));
            }
            finally {
                this.dialog = null;
            }
        }
        return 1;
    }

    public void close() {
        if (this.dialog instanceof ICommand) {
            ((ICommand)this.dialog).dispose();
            this.dialog = null;
        }
    }

    public boolean isClosed() {
        return !(this.dialog instanceof ICommand);
    }

    public Object getEditorValue() {
        return null;
    }
}

