/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.commands;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.requests.UnsetRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice.ConfiguratorDialog;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.types.UMLRTUIElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.menus.PopupMenuWithSeparators;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.UMLRTExtModelElementFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.providers.ParameterTypeContentProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.providers.PortTypeContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class InteractiveSetTypedElementTypeCommand
extends AbstractTransactionalCommand {
    private final TypedElement element;
    private final IElementType elementType;
    private final IElementType typeElementType;
    private final Function<? super IElementType, String> elementTypeLabelFunction;
    private Set<View> newTypeViews = Collections.emptySet();
    private boolean createNew;

    public InteractiveSetTypedElementTypeCommand(TypedElement element, IElementType elementType, IElementType typeElementType) {
        this(element, elementType, typeElementType, IElementType::getDisplayName);
    }

    public InteractiveSetTypedElementTypeCommand(TypedElement element, IElementType elementType, IElementType typeElementType, Function<? super IElementType, String> elementTypeLabelFunction) {
        super(TransactionUtil.getEditingDomain((EObject)element), "Set Type", InteractiveSetTypedElementTypeCommand.getWorkspaceFiles((EObject)element));
        this.element = element;
        this.elementType = elementType;
        this.typeElementType = typeElementType;
        this.elementTypeLabelFunction = elementTypeLabelFunction;
    }

    public TypedElement getElement() {
        return this.element;
    }

    public IElementType getElementType() {
        return this.elementType;
    }

    public IElementType getTypeElementType() {
        return this.typeElementType;
    }

    public String getDisplayName(IElementType elementType) {
        return this.elementTypeLabelFunction.apply((IElementType)elementType);
    }

    public void setNewTypeViews(Collection<? extends View> newTypeViews) {
        this.newTypeViews = ImmutableSet.copyOf(newTypeViews);
    }

    public Set<View> getNewTypeViews() {
        return this.newTypeViews;
    }

    public void setCreateNew(boolean createNew) {
        this.createNew = createNew;
    }

    public boolean isCreateNew() {
        return this.createNew;
    }

    private String createTypeItemLabel(IElementType typeToCreate) {
        return NLS.bind((String)(this.isCreateNew() ? "{0} with existing {1}..." : "Select existing {1}..."), (Object)this.getDisplayName(this.getElementType()), (Object)this.getDisplayName(typeToCreate));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        AbstractTransactionalCommand selectExistingTypeCommand = new AbstractTransactionalCommand(this.getEditingDomain(), this.getLabel(), this.getAffectedFiles()){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                UMLRTExtModelElementFactory meFactory = new UMLRTExtModelElementFactory();
                Type selectedType = null;
                ModelElement modelElement = meFactory.createFromSource(InteractiveSetTypedElementTypeCommand.this.getElement(), null);
                try {
                    IStaticContentProvider contentProvider = modelElement.getContentProvider("type");
                    ILabelProvider labelProvider = modelElement.getLabelProvider("type");
                    if (contentProvider != null) {
                        String dialogTitle = NLS.bind((String)"Select {0}", (Object)InteractiveSetTypedElementTypeCommand.this.getDisplayName(InteractiveSetTypedElementTypeCommand.this.getTypeElementType()));
                        selectedType = InteractiveSetTypedElementTypeCommand.this.browseType(InteractiveSetTypedElementTypeCommand.this.getElement(), dialogTitle, contentProvider, labelProvider);
                    }
                }
                finally {
                    modelElement.dispose();
                }
                if (selectedType == null) {
                    return CommandResult.newCancelledCommandResult();
                }
                return InteractiveSetTypedElementTypeCommand.setType(this.getEditingDomain(), InteractiveSetTypedElementTypeCommand.this.getElement(), selectedType);
            }
        };
        final Shell parentShell = Display.getCurrent().getActiveShell();
        Map<ICommand, String> createTypeCommands = this.getCreateTypeCommands();
        LinkedHashMap<2, String> wrappedCreateTypeCommands = new LinkedHashMap<2, String>();
        for (Map.Entry<ICommand, String> next : createTypeCommands.entrySet()) {
            final ICommand createType = next.getKey();
            String label = next.getValue();
            AbstractTransactionalCommand createNewTypeCommand = new AbstractTransactionalCommand(this.getEditingDomain(), this.getLabel(), this.getAffectedFiles()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Type createdType = null;
                    createType.execute(monitor, info);
                    CommandResult typeResult = createType.getCommandResult();
                    if (!typeResult.getStatus().isOK()) {
                        return typeResult;
                    }
                    createdType = typeResult.getReturnValue() instanceof List ? (Type)((List)typeResult.getReturnValue()).get(0) : (Type)typeResult.getReturnValue();
                    Set<View> dialogViews = InteractiveSetTypedElementTypeCommand.this.getNewTypeViews();
                    if (!dialogViews.isEmpty()) {
                        ConfiguratorDialog dlg = new ConfiguratorDialog(parentShell, true);
                        dlg.setTitle(NLS.bind((String)"Create New {0}", (Object)InteractiveSetTypedElementTypeCommand.this.getDisplayName(InteractiveSetTypedElementTypeCommand.this.getTypeElementType())));
                        dlg.setViews(InteractiveSetTypedElementTypeCommand.this.getNewTypeViews());
                        dlg.setInput(createdType);
                        if (dlg.open() != 0) {
                            return CommandResult.newCancelledCommandResult();
                        }
                    }
                    return InteractiveSetTypedElementTypeCommand.setType(this.getEditingDomain(), InteractiveSetTypedElementTypeCommand.this.getElement(), createdType);
                }
            };
            wrappedCreateTypeCommands.put(createNewTypeCommand, label);
        }
        List<ICommand> languageTypeCommands = this.getSetLanguageTypeCommands();
        LabelProvider popupLabels = new LabelProvider((ICommand)selectExistingTypeCommand, wrappedCreateTypeCommands){
            private final /* synthetic */ ICommand val$selectExistingTypeCommand;
            private final /* synthetic */ Map val$wrappedCreateTypeCommands;
            {
                this.val$selectExistingTypeCommand = iCommand;
                this.val$wrappedCreateTypeCommands = map;
            }

            public String getText(Object element) {
                String result = element == this.val$selectExistingTypeCommand ? NLS.bind((String)(InteractiveSetTypedElementTypeCommand.this.isCreateNew() ? "{0} with existing {1}..." : "Select existing {1}..."), (Object)InteractiveSetTypedElementTypeCommand.this.getDisplayName(InteractiveSetTypedElementTypeCommand.this.getElementType()), (Object)InteractiveSetTypedElementTypeCommand.this.getDisplayName(InteractiveSetTypedElementTypeCommand.this.getTypeElementType())) : (this.val$wrappedCreateTypeCommands.containsKey(element) ? (String)this.val$wrappedCreateTypeCommands.get(element) : (element instanceof SetLanguageTypeCommand ? ((SetLanguageTypeCommand)((Object)element)).getTypeLabel() : super.getText(element)));
                return result;
            }
        };
        ArrayList<Object> menuItems = new ArrayList<Object>(languageTypeCommands.size() + 2 + wrappedCreateTypeCommands.size());
        menuItems.addAll(languageTypeCommands);
        if (!languageTypeCommands.isEmpty()) {
            menuItems.add(new PopupMenuWithSeparators.Separator());
        }
        menuItems.add(selectExistingTypeCommand);
        menuItems.addAll(wrappedCreateTypeCommands.keySet());
        PopupMenuWithSeparators popupMenu = new PopupMenuWithSeparators(menuItems, (ILabelProvider)popupLabels);
        ICommand interactive = this.getPopupMenuCommand(parentShell, popupMenu);
        interactive.execute(monitor, info);
        return interactive.getCommandResult();
    }

    private ICommand getPopupMenuCommand(Shell parentShell, PopupMenu popupMenu) {
        return new PopupMenuCommand("Set Type", parentShell, popupMenu){
            private ICommand delegate;

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (!this.getPopupMenu().show((Control)this.getParentShell())) {
                    this.delegate = UnexecutableCommand.INSTANCE;
                    progressMonitor.setCanceled(true);
                    return CommandResult.newCancelledCommandResult();
                }
                this.delegate = (ICommand)this.getPopupMenu().getResult();
                this.delegate.execute(progressMonitor, info);
                IUndoContext[] iUndoContextArray = this.delegate.getContexts();
                int n = iUndoContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IUndoContext next = iUndoContextArray[n2];
                    if (!this.hasContext(next)) {
                        this.addContext(next);
                    }
                    ++n2;
                }
                return this.delegate.getCommandResult();
            }

            public boolean canUndo() {
                return this.delegate != null && this.delegate.canUndo();
            }

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.delegate.undo(progressMonitor, info);
                return this.delegate.getCommandResult();
            }

            public boolean canRedo() {
                return this.delegate != null && this.delegate.canRedo();
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.delegate.redo(progressMonitor, info);
                return this.delegate.getCommandResult();
            }
        };
    }

    static CommandResult setType(TransactionalEditingDomain domain, TypedElement element, Type type) throws ExecutionException {
        ICommand edit = null;
        IElementEditService editService = ElementEditServiceUtils.getCommandProvider((Object)element);
        if (editService != null) {
            edit = editService.getEditCommand((IEditCommandRequest)new SetRequest(domain, (EObject)element, (EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, (Object)type));
        }
        if (edit == null || !edit.canExecute()) {
            element.setType(type);
        } else {
            edit.execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (edit.getCommandResult().getStatus().getSeverity() >= 4) {
                return edit.getCommandResult();
            }
        }
        return CommandResult.newOKCommandResult((Object)type);
    }

    static CommandResult unsetType(TransactionalEditingDomain domain, TypedElement element) throws ExecutionException {
        ICommand edit = null;
        IElementEditService editService = ElementEditServiceUtils.getCommandProvider((Object)element);
        if (editService != null) {
            edit = editService.getEditCommand((IEditCommandRequest)new UnsetRequest(domain, (EObject)element, (EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE));
        }
        if (edit == null || !edit.canExecute()) {
            element.eUnset((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE);
        } else {
            edit.execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (edit.getCommandResult().getStatus().getSeverity() >= 4) {
                return edit.getCommandResult();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    private Map<ICommand, String> getCreateTypeCommands() {
        Map result;
        final Package container = this.getNearestPackage((Element)this.getElement());
        final IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)container);
        if (service == null) {
            Activator.log.error("Edit service not available for " + container, null);
            result = Collections.emptyMap();
        } else {
            final Function<IElementType, String> itemLabel = typeToCreate -> NLS.bind((String)(this.isCreateNew() ? "{0} with new {1}..." : "Create new {1}..."), (Object)this.getDisplayName(this.getElementType()), (Object)this.getDisplayName((IElementType)typeToCreate));
            result = (Map)new UMLSwitch<Map<ICommand, String>>(){

                public Map<ICommand, String> defaultCase(EObject object) {
                    return Collections.emptyMap();
                }

                public Map<ICommand, String> caseTypedElement(TypedElement object) {
                    return Collections.singletonMap(service.getEditCommand((IEditCommandRequest)new CreateElementRequest((EObject)container, InteractiveSetTypedElementTypeCommand.this.getTypeElementType())), (String)itemLabel.apply(InteractiveSetTypedElementTypeCommand.this.getTypeElementType()));
                }

                public Map<ICommand, String> caseParameter(Parameter object) {
                    LinkedHashMap<ICommand, String> result = new LinkedHashMap<ICommand, String>();
                    for (IElementType iElementType : Arrays.asList(UMLElementTypes.CLASS, UMLElementTypes.ENUMERATION)) {
                        ICommand command = service.getEditCommand((IEditCommandRequest)new CreateElementRequest((EObject)container, iElementType));
                        if (command == null || !command.canExecute()) continue;
                        result.put(command, (String)itemLabel.apply(iElementType));
                    }
                    return result;
                }
            }.doSwitch((EObject)this.getElement());
        }
        return result;
    }

    private Package getNearestPackage(Element element) {
        Package result = element.getNearestPackage();
        while (ProtocolContainerUtils.isProtocolContainer((EObject)result)) {
            result = result.getOwner().getNearestPackage();
        }
        return result;
    }

    protected Type browseType(TypedElement typedElement, String title, IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        Object[] selected;
        Type result = null;
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
        dialog.setContentProvider(this.getTypesContentProvider(typedElement, contentProvider));
        dialog.setLabelProvider(labelProvider);
        dialog.setTitle(title);
        if (dialog.open() == 0 && (selected = dialog.getResult()) != null && selected.length > 0) {
            Object oneSelected = selected[0];
            if (contentProvider instanceof IAdaptableContentProvider) {
                oneSelected = ((IAdaptableContentProvider)contentProvider).getAdaptedValue(oneSelected);
            }
            if (oneSelected instanceof Type) {
                result = (Type)oneSelected;
            }
        }
        return result;
    }

    private ITreeContentProvider getTypesContentProvider(TypedElement typedElement, final IStaticContentProvider contentProvider) {
        return (ITreeContentProvider)new UMLSwitch<ITreeContentProvider>(){

            public ITreeContentProvider defaultCase(EObject object) {
                return new EncapsulatedContentProvider((IStructuredContentProvider)EmptyContentProvider.instance);
            }

            public ITreeContentProvider caseTypedElement(TypedElement object) {
                return new EncapsulatedContentProvider((IStructuredContentProvider)contentProvider);
            }

            public ITreeContentProvider casePort(Port object) {
                return InteractiveSetTypedElementTypeCommand.this.getPortTypeContentProvider(contentProvider);
            }

            public ITreeContentProvider caseParameter(Parameter object) {
                return new ParameterTypeContentProvider(contentProvider);
            }
        }.doSwitch((EObject)typedElement);
    }

    private List<ICommand> getSetLanguageTypeCommands() {
        return (List)new UMLSwitch<List<ICommand>>(){

            public List<ICommand> defaultCase(EObject object) {
                return Collections.emptyList();
            }

            public List<ICommand> caseTypedElement(TypedElement object) {
                return InteractiveSetTypedElementTypeCommand.this.getPrimitiveSetLanguageTypeCommands(InteractiveSetTypedElementTypeCommand.this.getElementType(), object);
            }

            public List<ICommand> casePort(Port object) {
                if (InteractiveSetTypedElementTypeCommand.this.elementType.equals(UMLRTUIElementTypesEnumerator.EXTERNAL_PORT_CREATION_WITH_UI)) {
                    return Collections.emptyList();
                }
                return InteractiveSetTypedElementTypeCommand.this.getSystemProtocolsSetLanguageTypeCommands(InteractiveSetTypedElementTypeCommand.this.getElementType(), object);
            }

            public List<ICommand> caseProperty(Property object) {
                return Collections.emptyList();
            }
        }.doSwitch((EObject)this.getElement());
    }

    private ITreeContentProvider getPortTypeContentProvider(IStaticContentProvider contentProvider) {
        if (this.elementType.equals(UMLRTUIElementTypesEnumerator.EXTERNAL_PORT_CREATION_WITH_UI)) {
            return new PortTypeContentProvider(contentProvider){

                @Override
                public boolean isValidValue(Object element) {
                    boolean result = super.isValidValue(element);
                    if (result) {
                        EObject eObject = EMFHelper.getEObject((Object)element);
                        result = ProtocolUtils.isProtocol((EObject)eObject) != false && !SystemElementsUtils.isSystemProtocol((Collaboration)((Collaboration)eObject));
                    }
                    return result;
                }
            };
        }
        return new PortTypeContentProvider(contentProvider);
    }

    protected List<ICommand> getSystemProtocolsSetLanguageTypeCommands(IElementType elementType, Port element) {
        List<Object> result;
        IDefaultLanguage language = null;
        try {
            IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)element);
            Element root = Stream.iterate(element, Element::getOwner).filter(e -> e.getOwner() == null).findFirst().get();
            language = service.getActiveDefaultLanguage(root);
        }
        catch (ServiceException e2) {
            Activator.log.error((Throwable)e2);
        }
        if (language == null) {
            result = Collections.emptyList();
        } else {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
            Set types = language.getSystemProtocols(domain.getResourceSet());
            result = types.stream().map(SetLanguageTypeCommand.factory(domain, elementType, (TypedElement)element)).sorted(Comparator.comparing(SetLanguageTypeCommand::getTypeLabel)).collect(Collectors.toList());
        }
        return result;
    }

    private List<ICommand> getPrimitiveSetLanguageTypeCommands(IElementType elementType, final TypedElement element) {
        List<Object> result;
        IDefaultLanguage language = null;
        try {
            IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)element);
            Element root = Stream.iterate(element, Element::getOwner).filter(e -> e.getOwner() == null).findFirst().get();
            language = service.getActiveDefaultLanguage(root);
        }
        catch (ServiceException e2) {
            Activator.log.error((Throwable)e2);
        }
        if (language == null) {
            result = Collections.emptyList();
        } else {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
            Set types = language.getSpecificPrimitiveTypes(domain.getResourceSet());
            result = types.stream().map(SetLanguageTypeCommand.factory(domain, elementType, element)).sorted(Comparator.comparing(SetLanguageTypeCommand::getTypeLabel)).collect(Collectors.toList());
            result.add(0, (ICommand)new SetLanguageTypeCommand(domain, elementType, element, null){

                @Override
                String getTypeLabel() {
                    return Messages.NoTypeForTypedElement_Label;
                }

                @Override
                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (element.getType() != null) {
                        InteractiveSetTypedElementTypeCommand.unsetType(this.getEditingDomain(), element);
                    }
                    return CommandResult.newOKCommandResult();
                }
            });
        }
        return result;
    }

    private static class SetLanguageTypeCommand
    extends AbstractTransactionalCommand {
        private final IElementType elementType;
        private final TypedElement element;
        private final Type type;

        SetLanguageTypeCommand(TransactionalEditingDomain domain, IElementType elementType, TypedElement element, Type type) {
            super(domain, "Set Type", SetLanguageTypeCommand.getWorkspaceFiles((EObject)element));
            this.elementType = elementType;
            this.element = element;
            this.type = type;
        }

        String getTypeLabel() {
            return NLS.bind((String)"{0}", (Object)this.type.getLabel(), (Object)this.elementType.getDisplayName());
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return InteractiveSetTypedElementTypeCommand.setType(this.getEditingDomain(), this.element, this.type);
        }

        static Function<Type, SetLanguageTypeCommand> factory(TransactionalEditingDomain domain, IElementType elementType, TypedElement element) {
            return type -> new SetLanguageTypeCommand(domain, elementType, element, (Type)type);
        }
    }
}

