/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.ui.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.infra.widgets.databinding.ReferenceDialogObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.commands.InteractiveSetTypedElementTypeCommand;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.TypedElement;

public class MessageParameterTypeDialog
extends ReferenceDialog {
    private static final String CREATION_DIALOGS_CTX = "ppe:/context/org.eclipse.papyrusrt.umlrt.tooling.ui/dialogs/CreationDialogs.ctx";
    private static final String PARAMETER_TYPE_CREATION_VIEW = "Protocol Msg Parameter Creation Dialog";

    public MessageParameterTypeDialog(Composite parent, int style) {
        super(parent, style);
    }

    protected IObservableValue createWidgetObservable(IObservableValue modelProperty) {
        return new ReferenceDialogObservableValue(this, this.currentValueLabel, modelProperty, this.labelProvider){

            protected void doSetValue(Object value) {
                super.doSetValue(value);
                if (value == null) {
                    this.label.setText(this.labelProvider.getText(value));
                    this.label.setImage(this.labelProvider.getImage(value));
                }
            }
        };
    }

    protected void browseAction() {
        ResourceSet rset;
        Parameter parameter = (Parameter)this.getContextElement();
        final InteractiveSetTypedElementTypeCommand command = new InteractiveSetTypedElementTypeCommand((TypedElement)parameter, (IElementType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_PARAMETER, (IElementType)UMLElementTypes.CLASSIFIER, type -> type == UMLElementTypes.CLASSIFIER ? "Type" : type.getEClass().getName());
        try {
            Context context = PropertiesRuntime.getConfigurationManager().getContext(URI.createURI((String)CREATION_DIALOGS_CTX));
            Optional<Set> parameterTypeView = context.getViews().stream().filter(view -> PARAMETER_TYPE_CREATION_VIEW.equals(view.getName())).findFirst().map(Collections::singleton);
            parameterTypeView.ifPresent(views -> command.setNewTypeViews((Collection<? extends View>)views));
        }
        catch (IOException e) {
            Activator.log.error("Failed to load property sheet views for new parameter types", (Throwable)e);
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)parameter);
        if (domain == null && (rset = NestedEditingDialogContext.getInstance().getResourceSet()) != null) {
            domain = TransactionUtil.getEditingDomain((ResourceSet)rset);
        }
        if (domain != null) {
            GMFtoEMFCommandWrapper wrapper = new GMFtoEMFCommandWrapper((ICommand)command){

                public void execute() {
                    super.execute();
                    CommandResult commandResult = command.getCommandResult();
                    if (commandResult != null && commandResult.getStatus() != null && commandResult.getStatus().getSeverity() >= 8) {
                        throw new OperationCanceledException();
                    }
                }
            };
            domain.getCommandStack().execute((Command)wrapper);
        }
    }
}

