/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.StringCombo;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.UnchangedObject;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.ConstantContentProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Property;

public class PropertyReplicationComboDialog
extends StringCombo {
    private Button browseButton;
    private String historyId;
    private TreeSelectorDialog dialog;
    private Timer timer;
    private TimerTask changeColorTask;

    public PropertyReplicationComboDialog(Composite parent, int style) {
        super(parent, style);
        ((GridLayout)this.getLayout()).numColumns = 2;
        this.browseButton = factory.createButton((Composite)this, "Browse...", 8);
        GridData gridData = new GridData();
        gridData.exclude = true;
        this.browseButton.setLayoutData((Object)gridData);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object constant;
                Object[] result;
                Object capsulepart = PropertyReplicationComboDialog.this.getContextElement();
                ResourceSet rs = ((EObject)capsulepart).eResource().getResourceSet();
                PropertyReplicationComboDialog.this.dialog = new TreeSelectorDialog(PropertyReplicationComboDialog.this.getShell());
                if (PropertyReplicationComboDialog.this.labelText != null) {
                    PropertyReplicationComboDialog.this.dialog.setTitle(PropertyReplicationComboDialog.this.labelText);
                }
                PropertyReplicationComboDialog.this.historyId = String.format("history_%s:%s:%s", ((EObject)capsulepart).eResource().getURI(), "String", "Replication");
                ConstantContentProvider contentProvider = new ConstantContentProvider();
                EMFGraphicalContentProvider graphicalProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)contentProvider, rs, PropertyReplicationComboDialog.this.historyId);
                PropertyReplicationComboDialog.this.dialog.setInput(((EObject)capsulepart).eResource().getContents().get(0));
                PropertyReplicationComboDialog.this.dialog.setContentProvider((ITreeContentProvider)graphicalProvider);
                PropertyReplicationComboDialog.this.dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                int code = PropertyReplicationComboDialog.this.dialog.open();
                if (code == 0 && (result = PropertyReplicationComboDialog.this.dialog.getResult()).length > 0 && (constant = result[0]) instanceof Property) {
                    PropertyReplicationComboDialog.this.setResult((Property)constant);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setResult(Property cst) {
        this.setValue(cst.getQualifiedName());
        this.updateControls();
    }

    protected IObservableValue getObservableValue() {
        return new CapsuleComboObservableValue();
    }

    private void cancelChangeColorTask() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
            this.changeColorTask = null;
        }
    }

    private void changesColorField() {
        if (this.binding != null) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelChangeColorTask();
            this.changeColorTask = new TimerTask(){

                @Override
                public void run() {
                    if (PropertyReplicationComboDialog.this.isDisposed()) {
                        return;
                    }
                    PropertyReplicationComboDialog.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            PropertyReplicationComboDialog.this.combo.setBackground(DEFAULT);
                            PropertyReplicationComboDialog.this.combo.update();
                        }
                    });
                }
            };
            if (this.errorBinding) {
                this.combo.setBackground(ERROR);
                this.combo.update();
            } else {
                IStatus status = (IStatus)this.binding.getValidationStatus().getValue();
                switch (status.getSeverity()) {
                    case 0: {
                        this.timer.schedule(this.changeColorTask, 600L);
                        this.combo.setBackground(VALID);
                        this.combo.update();
                        break;
                    }
                    case 4: {
                        this.combo.setBackground(ERROR);
                        this.combo.update();
                        break;
                    }
                    default: {
                        this.combo.setBackground(DEFAULT);
                        this.combo.update();
                    }
                }
            }
        }
    }

    class CapsuleComboObservableValue
    extends AbstractObservableValue
    implements SelectionListener,
    KeyListener,
    FocusListener {
        private String previousValue;

        public CapsuleComboObservableValue() {
            this.previousValue = PropertyReplicationComboDialog.this.combo.getText();
            PropertyReplicationComboDialog.this.combo.addSelectionListener((SelectionListener)this);
            PropertyReplicationComboDialog.this.combo.addKeyListener((KeyListener)this);
            PropertyReplicationComboDialog.this.combo.addFocusListener((FocusListener)this);
        }

        public Object getValueType() {
            return String.class;
        }

        protected String doGetValue() {
            return PropertyReplicationComboDialog.this.combo.getText();
        }

        protected void doSetValue(Object value) {
            if (PropertyReplicationComboDialog.this.modelProperty instanceof AggregatedObservable && ((AggregatedObservable)PropertyReplicationComboDialog.this.modelProperty).hasDifferentValues()) {
                PropertyReplicationComboDialog.this.combo.setText(UnchangedObject.instance.toString());
            } else if (value instanceof String) {
                this.previousValue = (String)value;
                PropertyReplicationComboDialog.this.combo.setText(this.previousValue);
            }
        }

        public void keyReleased(KeyEvent e) {
            if ((e.keyCode == 13 || e.keyCode == 0x1000050) && e.stateMask == 0) {
                this.maybeFireChange();
                PropertyReplicationComboDialog.this.changesColorField();
                e.doit = false;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.maybeFireChange();
        }

        public void focusLost(FocusEvent e) {
            this.maybeFireChange();
        }

        void maybeFireChange() {
            String currentValue = this.doGetValue();
            if (currentValue == null ? this.previousValue != null : !currentValue.equals(this.previousValue)) {
                this.doFireChange();
            }
        }

        private void doFireChange() {
            String currentValue;
            final String oldValue = this.previousValue;
            this.previousValue = currentValue = this.doGetValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return currentValue;
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }
    }
}

