/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.external.predefined;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonFactory;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTProfileUtil;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RTSModelLibraryUtils {
    @Deprecated
    private static ResourceSet resourceSet;
    @Deprecated
    private static boolean reload;
    private static Model RTSModelLibrary;
    public static final String RTS_LIB_ANNOTATION_NAME = "RTSLibraryElement";
    public static final String RTS_MODLIB_PATHMAP;
    public static final String RTS_MODLIB_ROOT_ID;
    public static final String RTS_LIBRARY_NAME = "UMLRT-RTS";
    public static final URI RTS_LIBRARY_URI;
    public static final String RTS_LIBRARY_URI_STR;
    @Deprecated
    private static Object resolvedRTSLibUri;
    public static final String T_RTS_MODLIB_PATHMAP = "pathmap://UMLRTRTSLIB/TUMLRT-RTS.umlrt";
    public static final String T_RTS_LIBRARY_NAME = "RTSLibrary";
    public static final URI T_RTS_LIBRARY_URI;
    public static final String T_RTS_LIBRARY_URI_STR;
    public static final String FRAME_PROTOCOL_NAME = "Frame";
    public static final String TIMING_PROTOCOL_NAME = "Timing";
    public static final String LOG_PROTOCOL_NAME = "Log";
    public static final String BASECOMM_PROTOCOL_NAME = "UMLRTBaseCommProtocol";
    public static final String TIMEOUT_MESSAGE_NAME = "timeout";
    public static final String RTBOUND_MESSAGE_NAME = "rtBound";
    public static final String RTUNBOUND_MESSAGE_NAME = "rtUnbound";
    public static final String CAPSULE_ID_TYPE_NAME = "UMLRTCapsuleId";
    public static final String TIMER_ID_TYPE_NAME = "UMLRTTimerId";
    public static final String TIME_SPEC_TYPE_NAME = "UMLRTTimespec";
    public static final String TIME_SPEC_2_TYPE_NAME = "UMLRTTimeSpec";
    public static final String MESSAGE_TYPE_NAME = "UMLRTMessage";
    public static final String INTERNAL_PACKAGE_NAME = "Internal";
    private static Collaboration FRAME_PROTOCOL;
    private static Collaboration TIMING_PROTOCOL;
    private static Collaboration LOG_PROTOCOL;
    private static Collaboration BASECOMM_PROTOCOL;
    private static Object TIMEOUT_MESSAGE;
    private static Object RTBOUND_MESSAGE;
    private static Object RTUNBOUND_MESSAGE;

    static {
        reload = true;
        RTS_MODLIB_PATHMAP = RTSModelLibraryMetadata.INSTANCE.getPathmap();
        RTS_MODLIB_ROOT_ID = RTSModelLibraryMetadata.INSTANCE.getRootId();
        RTS_LIBRARY_URI = URI.createURI((String)RTS_MODLIB_PATHMAP).appendFragment(RTS_MODLIB_ROOT_ID);
        RTS_LIBRARY_URI_STR = RTS_LIBRARY_URI.toPlatformString(false);
        resolvedRTSLibUri = null;
        T_RTS_LIBRARY_URI = URI.createURI((String)T_RTS_MODLIB_PATHMAP);
        T_RTS_LIBRARY_URI_STR = T_RTS_LIBRARY_URI.toPlatformString(false);
        FRAME_PROTOCOL = null;
        TIMING_PROTOCOL = null;
        LOG_PROTOCOL = null;
        BASECOMM_PROTOCOL = null;
        TIMEOUT_MESSAGE = null;
        RTBOUND_MESSAGE = null;
        RTUNBOUND_MESSAGE = null;
    }

    public static Object setRTSModelLibrary(Model model) {
        IStatus _xifexpression = null;
        if (model != null) {
            RTSModelLibrary = model;
            _xifexpression = RTSModelLibrary;
        } else {
            _xifexpression = XTUMLRTLogger.error((String)"The RTS model library was not loaded or registered.");
        }
        return _xifexpression;
    }

    public static boolean addSysAnnotation(NamedElement element) {
        boolean _xblockexpression = false;
        Annotation sysAnnotation = CommonFactory.eINSTANCE.createAnnotation();
        sysAnnotation.setName(RTS_LIB_ANNOTATION_NAME);
        EList _annotations = element.getAnnotations();
        _xblockexpression = _annotations.add((Object)sysAnnotation);
        return _xblockexpression;
    }

    @Deprecated
    public static Package loadPackage(URI fullURI) {
        if (resourceSet == null) {
            String _platformString = fullURI.toPlatformString(true);
            String _plus = "Unable to load package " + _platformString;
            String _plus_1 = String.valueOf(_plus) + "; Resource set is null";
            XTUMLRTLogger.warning((String)_plus_1);
            return null;
        }
        Resource resource = resourceSet.getResource(fullURI, true);
        if (resource == null) {
            String _platformString_1 = fullURI.toPlatformString(true);
            String _plus_2 = "Unable to load package " + _platformString_1;
            String _plus_3 = String.valueOf(_plus_2) + "; resource is null";
            XTUMLRTLogger.warning((String)_plus_3);
            return null;
        }
        EList contents = resource.getContents();
        if (contents == null) {
            String _platformString_2 = fullURI.toPlatformString(true);
            String _plus_4 = "Unable to load package " + _platformString_2;
            String _plus_5 = String.valueOf(_plus_4) + "; contents is null";
            XTUMLRTLogger.warning((String)_plus_5);
            return null;
        }
        Object eobj = EcoreUtil.getObjectByType((Collection)contents, (EClassifier)UMLPackage.Literals.PACKAGE);
        if (eobj == null || !(eobj instanceof Package)) {
            String _platformString_3 = fullURI.toPlatformString(true);
            String _plus_6 = "Unable to load package " + _platformString_3;
            String _plus_7 = String.valueOf(_plus_6) + "; first element is null or not a UML Package";
            XTUMLRTLogger.warning((String)_plus_7);
            return null;
        }
        Package pkg = (Package)eobj;
        return pkg;
    }

    @Deprecated
    public static Model loadRTSModelLibrary() {
        String _qualifiedName;
        boolean _notEquals;
        boolean _not;
        if (!reload) {
            Object _xifexpression = null;
            if (resourceSet == null) {
                XTUMLRTLogger.warning((String)"Unable to load RTS Model Library; Resource set is null");
                return null;
            }
            return _xifexpression;
        }
        URIConverter uriConverter = resourceSet.getURIConverter();
        if (uriConverter == null) {
            XTUMLRTLogger.warning((String)"Unable to load RTS Model Library; Resource set's URI converter is null");
            return null;
        }
        URI normalizedRTSLibURI = uriConverter.normalize(RTS_LIBRARY_URI);
        Package pkg = RTSModelLibraryUtils.loadPackage(normalizedRTSLibURI);
        if (pkg == null || !(pkg instanceof Model)) {
            XTUMLRTLogger.warning((String)"Unable to load RTS Model Library; contained UML Package is not a UML Model");
            return null;
        }
        boolean _isModelLibrary = pkg.isModelLibrary();
        boolean bl = _not = !_isModelLibrary;
        if (_not) {
            XTUMLRTLogger.warning((String)"Loaded model is not a model library");
        }
        boolean bl2 = _notEquals = !Objects.equal((Object)(_qualifiedName = pkg.getQualifiedName()), (Object)RTS_LIBRARY_NAME);
        if (_notEquals) {
            XTUMLRTLogger.warning((String)"Loaded model library's name is not RTS");
        }
        RTSModelLibrary = (Model)pkg;
        return RTSModelLibrary;
    }

    @Deprecated
    public static Model reloadRTSModelLibrary() {
        Model _xblockexpression = null;
        reload = true;
        _xblockexpression = RTSModelLibraryUtils.loadRTSModelLibrary();
        return _xblockexpression;
    }

    @Deprecated
    public static boolean setReload(boolean flag) {
        reload = flag;
        return reload;
    }

    @Deprecated
    public static boolean setResourceSet(ResourceSet resSet) {
        boolean _xifexpression = false;
        if (resSet != resourceSet || resourceSet == null) {
            boolean _xblockexpression = false;
            resourceSet = resSet;
            reload = true;
            _xifexpression = _xblockexpression = true;
        } else {
            reload = false;
            _xifexpression = false;
        }
        return _xifexpression;
    }

    @Deprecated
    public static Object setResolvedRTSModelLibraryLocation(URI resolvedLocation) {
        URI _xblockexpression = null;
        URIConverter uriConverter = resourceSet.getURIConverter();
        URI _xifexpression = null;
        if (uriConverter != null) {
            URI _xblockexpression_1 = null;
            URI _createURI = URI.createURI((String)RTS_MODLIB_PATHMAP);
            URI normalizedRTSLibURI = uriConverter.normalize(_createURI);
            Map _uRIMap = uriConverter.getURIMap();
            _uRIMap.put(normalizedRTSLibURI, resolvedLocation);
            resolvedRTSLibUri = resolvedLocation;
            _xifexpression = _xblockexpression_1 = resolvedRTSLibUri;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Deprecated
    public static Model getRTSModelLibrary() {
        return RTSModelLibrary;
    }

    @Deprecated
    public static Object getResolvedRTSModelLibraryLocation() {
        return resolvedRTSLibUri;
    }

    public static Collaboration getProtocol(Package packge, String name) {
        Collaboration _xblockexpression = null;
        PackageableElement protocolContainer = packge.getPackagedElement(name);
        Collaboration _xifexpression = null;
        if (protocolContainer != null && protocolContainer instanceof Package) {
            Collaboration _xblockexpression_1 = null;
            PackageableElement protocol = ((Package)protocolContainer).getPackagedElement(name);
            Collaboration _xifexpression_1 = null;
            if (protocol != null && protocol instanceof Collaboration) {
                _xifexpression_1 = (Collaboration)protocol;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Collaboration getFrameProtocol() {
        Collaboration _xblockexpression = null;
        if (FRAME_PROTOCOL == null || reload) {
            Collaboration _protocol;
            FRAME_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)RTSModelLibrary, FRAME_PROTOCOL_NAME);
        }
        _xblockexpression = FRAME_PROTOCOL;
        return _xblockexpression;
    }

    public static Collaboration getTimingProtocol() {
        Collaboration _xblockexpression = null;
        if (TIMING_PROTOCOL == null || reload) {
            Collaboration _protocol;
            TIMING_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)RTSModelLibrary, TIMING_PROTOCOL_NAME);
        }
        _xblockexpression = TIMING_PROTOCOL;
        return _xblockexpression;
    }

    public static Collaboration getLogProtocol() {
        Collaboration _xblockexpression = null;
        if (LOG_PROTOCOL == null || reload) {
            Collaboration _protocol;
            LOG_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)RTSModelLibrary, LOG_PROTOCOL_NAME);
        }
        _xblockexpression = LOG_PROTOCOL;
        return _xblockexpression;
    }

    public static Collaboration getBaseCommProtocol() {
        PackageableElement internalPackage;
        Collaboration _xblockexpression = null;
        if ((BASECOMM_PROTOCOL == null || reload) && (internalPackage = RTSModelLibrary.getPackagedElement(INTERNAL_PACKAGE_NAME)) instanceof Package) {
            Collaboration _protocol;
            BASECOMM_PROTOCOL = _protocol = RTSModelLibraryUtils.getProtocol((Package)internalPackage, BASECOMM_PROTOCOL_NAME);
        }
        _xblockexpression = BASECOMM_PROTOCOL;
        return _xblockexpression;
    }

    public static Object getTimeout() {
        Object _xblockexpression = null;
        if (TIMEOUT_MESSAGE == null || reload) {
            Collaboration _timingProtocol = RTSModelLibraryUtils.getTimingProtocol();
            Iterable<Operation> _inProtocolMessages = UMLRTProfileUtil.getInProtocolMessages(_timingProtocol, false);
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.TIMEOUT_MESSAGE_NAME);
                }
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(_inProtocolMessages, (Functions.Function1)_function);
            TIMEOUT_MESSAGE = _findFirst;
        }
        _xblockexpression = TIMEOUT_MESSAGE;
        return _xblockexpression;
    }

    public static Object getRtBound() {
        Object _xblockexpression = null;
        if (RTBOUND_MESSAGE == null || reload) {
            Collaboration _baseCommProtocol = RTSModelLibraryUtils.getBaseCommProtocol();
            Iterable<Operation> _inOutProtocolMessages = UMLRTProfileUtil.getInOutProtocolMessages(_baseCommProtocol);
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.RTBOUND_MESSAGE_NAME);
                }
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(_inOutProtocolMessages, (Functions.Function1)_function);
            RTBOUND_MESSAGE = _findFirst;
        }
        _xblockexpression = RTBOUND_MESSAGE;
        return _xblockexpression;
    }

    public static Object getRtUnbound() {
        Object _xblockexpression = null;
        if (RTUNBOUND_MESSAGE == null || reload) {
            Collaboration _baseCommProtocol = RTSModelLibraryUtils.getBaseCommProtocol();
            Iterable<Operation> _inOutProtocolMessages = UMLRTProfileUtil.getInOutProtocolMessages(_baseCommProtocol);
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.RTUNBOUND_MESSAGE_NAME);
                }
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(_inOutProtocolMessages, (Functions.Function1)_function);
            RTUNBOUND_MESSAGE = _findFirst;
        }
        _xblockexpression = RTUNBOUND_MESSAGE;
        return _xblockexpression;
    }

    public static boolean hasSysAnnotation(NamedElement element) {
        return element != null && element.getAnnotations() != null && IterableExtensions.exists((Iterable)element.getAnnotations(), (Functions.Function1)new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)RTSModelLibraryUtils.RTS_LIB_ANNOTATION_NAME);
            }
        });
    }

    public static boolean isRTSModelLibrary(Package packge) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)packge, (Object)RTSModelLibrary);
        if (_equals) {
            return true;
        }
        Resource _eResource = packge.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        URIConverter uriConverter = _resourceSet.getURIConverter();
        URI packageURI = EcoreUtil.getURI((EObject)packge);
        URI normalizedPackageURI = uriConverter.normalize(packageURI);
        URI normalizedRTSLibURI = uriConverter.normalize(RTS_LIBRARY_URI);
        _xblockexpression = packge instanceof Model && packge.getQualifiedName().equals(RTS_LIBRARY_NAME) && Objects.equal((Object)normalizedPackageURI, (Object)normalizedRTSLibURI);
        return _xblockexpression;
    }

    public static boolean isRTSModelLibrary(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        return model != null && Objects.equal((Object)model.getName(), (Object)RTS_LIBRARY_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)model);
    }

    public static boolean isSystemElement(CommonElement element) {
        return element != null && element instanceof NamedElement && RTSModelLibraryUtils.hasSysAnnotation((NamedElement)element);
    }

    public static boolean isSystemElement(Element element) {
        return element.getModel() != null && RTSModelLibraryUtils.isRTSModelLibrary((Package)element.getModel());
    }

    public static boolean isCapsuleId(NamedElement type) {
        return type != null && type.getName() != null && Objects.equal((Object)type.getName(), (Object)CAPSULE_ID_TYPE_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)type);
    }

    public static boolean isTextualRTSModelLibrary(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        boolean _xblockexpression = false;
        if (model == null) {
            return false;
        }
        Resource _eResource = model.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        URIConverter uriConverter = _resourceSet.getURIConverter();
        URI packageURI = EcoreUtil.getURI((EObject)model);
        URI normalizedPackageURI = uriConverter.normalize(packageURI);
        URI normalizedRTSLibURI = uriConverter.normalize(T_RTS_LIBRARY_URI);
        _xblockexpression = Objects.equal((Object)model.getName(), (Object)T_RTS_LIBRARY_NAME) && Objects.equal((Object)normalizedPackageURI.toPlatformString(true), (Object)normalizedRTSLibURI.toPlatformString(true));
        return _xblockexpression;
    }

    public static boolean isTextualSystemElement(CommonElement element) {
        return element != null && XTUMLRTUtil.getRoot((CommonElement)element) instanceof org.eclipse.papyrusrt.xtumlrt.common.Model && RTSModelLibraryUtils.isTextualRTSModelLibrary((org.eclipse.papyrusrt.xtumlrt.common.Model)XTUMLRTUtil.getRoot((CommonElement)element));
    }

    public static boolean isTimerId(NamedElement type) {
        return type != null && type.getName() != null && Objects.equal((Object)type.getName(), (Object)TIMER_ID_TYPE_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)type);
    }

    public static boolean isTimerSpec(NamedElement type) {
        return type != null && type.getName() != null && (Objects.equal((Object)type.getName(), (Object)TIME_SPEC_2_TYPE_NAME) || Objects.equal((Object)type.getName(), (Object)TIME_SPEC_TYPE_NAME)) && RTSModelLibraryUtils.isSystemElement((CommonElement)type);
    }

    public static boolean isMessage(NamedElement type) {
        return type != null && type.getName() != null && Objects.equal((Object)type.getName(), (Object)MESSAGE_TYPE_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)type);
    }

    public static boolean isBaseCommProtocol(Protocol protocol) {
        return protocol != null && protocol.getName() != null && Objects.equal((Object)protocol.getName(), (Object)BASECOMM_PROTOCOL_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)protocol);
    }

    public static boolean isFrameProtocol(Protocol protocol) {
        return protocol != null && protocol.getName() != null && Objects.equal((Object)protocol.getName(), (Object)FRAME_PROTOCOL_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)protocol);
    }

    public static boolean isTimingProtocol(Protocol protocol) {
        return protocol != null && protocol.getName() != null && Objects.equal((Object)protocol.getName(), (Object)TIMING_PROTOCOL_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)protocol);
    }

    public static boolean isLogProtocol(Protocol protocol) {
        return protocol != null && protocol.getName() != null && Objects.equal((Object)protocol.getName(), (Object)LOG_PROTOCOL_NAME) && RTSModelLibraryUtils.isSystemElement((CommonElement)protocol);
    }

    public static Iterable<Signal> getAllUserSignals(Protocol protocol) {
        Iterable _allSignals = XTUMLRTUtil.getAllSignals((Protocol)protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)it);
                return !_isSystemElement;
            }
        };
        return IterableExtensions.filter((Iterable)_allSignals, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getUserSignals(Protocol protocol) {
        Iterable _signals = XTUMLRTUtil.getSignals((Protocol)protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isSystemElement = RTSModelLibraryUtils.isSystemElement((CommonElement)it);
                return !_isSystemElement;
            }
        };
        return IterableExtensions.filter((Iterable)_signals, (Functions.Function1)_function);
    }
}

