/*******************************************************************************
* Copyright (c) 2014-2016 Zeligsoft (2009) Limited  and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.papyrusrt.xtumlrt.trans.preproc

import org.eclipse.papyrusrt.xtumlrt.trans.Transformation
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine
import org.eclipse.papyrusrt.xtumlrt.trans.TransformationContext
import org.eclipse.papyrusrt.xtumlrt.common.CommonFactory
import org.eclipse.papyrusrt.xtumlrt.statemach.CompositeState
import org.eclipse.papyrusrt.xtumlrt.statemach.State
import org.eclipse.xtend.lib.annotations.Accessors
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition
import org.eclipse.papyrusrt.xtumlrt.statemach.SimpleState
import org.eclipse.papyrusrt.xtumlrt.statemach.StatemachFactory
import org.eclipse.papyrusrt.xtumlrt.util.GlobalConstants
import org.eclipse.papyrusrt.xtumlrt.statemach.InitialPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.DeepHistory
import org.eclipse.papyrusrt.xtumlrt.statemach.ChoicePoint
import org.eclipse.papyrusrt.xtumlrt.statemach.JunctionPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.EntryPoint
import org.eclipse.papyrusrt.xtumlrt.statemach.ExitPoint
import org.eclipse.papyrusrt.xtumlrt.statemachext.StatemachextFactory

class StateMachineDefaultsPreprocessor implements Transformation<StateMachine, StateMachine>
{
    var entryActionCounter = 0
    var exitActionCounter = 0
    var transitionActionCounter = 0
    var guardCounter = 0
    var choicePointCounter = 0
    var junctionPointCounter = 0
    var entryPointCounter = 0
    var exitPointCounter = 0

    @Accessors boolean createEmptyActions = true
    @Accessors boolean createDefaultGuards = false
    
    override transform( StateMachine input, TransformationContext context )
    {
        entryActionCounter = 0
        exitActionCounter = 0
        transitionActionCounter = 0
        guardCounter = 0
        choicePointCounter = 0
        junctionPointCounter = 0
        entryPointCounter = 0
        exitPointCounter = 0
        if (input !== null) visit( input )
        return input    // This is an in-place transformation
    }
    
    dispatch def void visit( StateMachine stateMachine )
    {
        if (stateMachine.top === null)
            stateMachine.top = StatemachFactory.eINSTANCE.createCompositeState
        else
            visit( stateMachine.top )
    }
    
    protected def void visitState( State state )
    {
        if (createEmptyActions)
        {
            if (state.entryAction === null)
            {
                val newAction = StatemachextFactory.eINSTANCE.createEntryAction
                newAction.name = GlobalConstants.ENTRY_ACTION_BASE_NAME + entryActionCounter++
                newAction.source = ""
                state.entryAction = newAction
            }
            if (state.exitAction === null)
            {
                val newAction = StatemachextFactory.eINSTANCE.createExitAction
                newAction.name = GlobalConstants.EXIT_ACTION_BASE_NAME + exitActionCounter++
                newAction.source = ""
                state.exitAction = newAction
            }
        }
    }
    
    dispatch def void visit( SimpleState simpleState )
    {
        visitState( simpleState )
    }
    
    dispatch def void visit( CompositeState compositeState )
    {
        visitState( compositeState )
        compositeState.initial?.visit
        compositeState.deepHistory?.visit
        compositeState.substates.forEach[ visit ]
        compositeState.transitions.forEach[ visit ]
    }
    
    dispatch def void visit( InitialPoint pseudostate )
    {
        if (pseudostate.name === null || pseudostate.name.empty)
            pseudostate.name = "initial"
    }
    
    dispatch def void visit( DeepHistory pseudostate )
    {
        if (pseudostate.name === null || pseudostate.name.empty)
            pseudostate.name = "history"
    }
    
    dispatch def void visit( ChoicePoint pseudostate )
    {
        if (pseudostate.name === null || pseudostate.name.empty)
            pseudostate.name = "choice" + choicePointCounter++
    }
    
    dispatch def void visit( JunctionPoint pseudostate )
    {
        if (pseudostate.name === null || pseudostate.name.empty)
            pseudostate.name = "junction" + junctionPointCounter++
    }
    
    dispatch def void visit( EntryPoint pseudostate )
    {
        if (pseudostate.name === null || pseudostate.name.empty)
            pseudostate.name = "entrypoint" + entryPointCounter++
    }
    
    dispatch def void visit( ExitPoint pseudostate )
    {
        if (pseudostate.name === null || pseudostate.name.empty)
            pseudostate.name = "exitpoint" + exitPointCounter++
    }
    
    dispatch def void visit( Transition transition )
    {
        if (transition.name === null || transition.name.empty)
            transition.name = GlobalConstants.TRANS_ACTION_BASE_NAME + transitionActionCounter
        if (createEmptyActions && transition.actionChain === null)
        {
            val newAction = StatemachFactory.eINSTANCE.createActionChain
            newAction.name = GlobalConstants.ACTION_CHAIN_BASE_NAME + transitionActionCounter
            transition.actionChain = newAction
        }
        transitionActionCounter++
        if (createDefaultGuards && transition.guard === null)
        {
            val newGuard = StatemachFactory.eINSTANCE.createGuard
            newGuard.name = GlobalConstants.GUARD_BASE_NAME + guardCounter
            val newGuardBody = CommonFactory.eINSTANCE.createActionCode
            newGuardBody.name = GlobalConstants.ACTION_BASE_NAME + guardCounter
            newGuardBody.source = "return true;"  // TODO: This should create something according to the specific action language, so this must be replaced by a language-independent approach.
            newGuard.body = newGuardBody
            transition.guard = newGuard
            guardCounter++
        }
    }
}