/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.xtext.xbase.lib.Functions;

public class XTUMLRTLogger
extends Plugin {
    public static final String ID = "org.eclipse.papyrusrt.xtumlrt";
    private static final Logger LOGGER = Logger.getLogger("XTUMLRT");
    private static final XTUMLRTLogger INSTANCE = new XTUMLRTLogger();
    private static boolean standalone = false;
    private static boolean textual = false;
    private static boolean printStackTrace;

    public XTUMLRTLogger() {
        LOGGER.setUseParentHandlers(false);
    }

    public static XTUMLRTLogger getDefault() {
        return INSTANCE;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static IStatus debug(String message) {
        Status status = new Status(1, ID, "[DEBUG]" + message);
        if (standalone) {
            XTUMLRTLogger.getLogger().finest(message);
        }
        return status;
    }

    public static IStatus debug(Functions.Function0<CharSequence> thunk) {
        Status status = null;
        if (!standalone || XTUMLRTLogger.getLogger().getLevel().intValue() > Level.FINEST.intValue()) {
            status = new Status(1, ID, "[DEBUG] " + thunk.toString());
        } else {
            String message = ((CharSequence)thunk.apply()).toString();
            status = new Status(1, ID, "[DEBUG]\n" + message);
            if (standalone) {
                XTUMLRTLogger.getLogger().finest(message);
            }
        }
        return status;
    }

    public static IStatus info(String message) {
        Status status = new Status(1, ID, message);
        if (standalone) {
            XTUMLRTLogger.getLogger().info(message);
        } else {
            XTUMLRTLogger.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static IStatus warning(String message) {
        Status status = new Status(2, ID, message);
        if (standalone) {
            XTUMLRTLogger.getLogger().warning(message);
        } else {
            XTUMLRTLogger.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static IStatus error(String message) {
        return XTUMLRTLogger.error(message, null);
    }

    public static IStatus error(Throwable e) {
        return XTUMLRTLogger.error("Error", e);
    }

    public static IStatus error(String message, Throwable e) {
        MultiStatus status = null;
        if (e instanceof DetailedException) {
            status = new MultiStatus(ID, 4, message, null);
            String details = e.toString();
            String[] stringArray = details.split(System.getProperty("line.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                status.add((IStatus)new Status(4, ID, line));
                ++n2;
            }
        } else {
            status = new Status(4, ID, message, e);
        }
        if (standalone) {
            XTUMLRTLogger.getLogger().severe(status.toString());
            if (printStackTrace && e != null) {
                e.printStackTrace();
            }
        } else {
            XTUMLRTLogger.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static void setStandalone(boolean printTrace) {
        standalone = true;
        printStackTrace = printTrace;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static void setTextual(boolean printTrace) {
        textual = true;
        printStackTrace = printTrace;
    }

    public static boolean isTextual() {
        return textual;
    }
}

