/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.codegen.ui.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.codegen.papyrus.UMLRTGenerator;
import org.eclipse.papyrusrt.codegen.papyrus.cdt.EditorUtil;
import org.eclipse.papyrusrt.xtumlrt.common.ActionCode;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.statemach.ActionChain;
import org.eclipse.papyrusrt.xtumlrt.statemach.Guard;
import org.eclipse.papyrusrt.xtumlrt.statemach.State;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition;
import org.eclipse.papyrusrt.xtumlrt.statemach.Trigger;
import org.eclipse.papyrusrt.xtumlrt.statemach.Vertex;
import org.eclipse.papyrusrt.xtumlrt.statemachext.EntryAction;
import org.eclipse.papyrusrt.xtumlrt.statemachext.ExitAction;
import org.eclipse.papyrusrt.xtumlrt.statemachext.TransitionAction;
import org.eclipse.papyrusrt.xtumlrt.trans.preproc.ModelPreprocessor;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPort;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTTrigger;
import org.eclipse.papyrusrt.xtumlrt.xtext.codegen.ui.handlers.UmlrtXtextHandler;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.UMLPackage;

public class EditSourceHandler
extends AbstractHandler {
    protected static final ModelPreprocessor MODEL_PREPROCESSOR = new ModelPreprocessor();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selected;
        EObject eobj;
        IStructuredSelection selection;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && !(selection = (IStructuredSelection)sel).isEmpty() && (eobj = UmlrtXtextHandler.getEObject(selected = selection.getFirstElement())) != null) {
            EObject eobjRoot = EcoreUtil.getRootContainer((EObject)eobj);
            UmlrtXtextHandler.generate(eobjRoot);
            MultiStatus rc = new MultiStatus("org.eclipse.papyrusrt.codegen.papyrus", 0, "Edit Source Action Status", null);
            if (eobj instanceof TransitionAction && eobj.eContainer() instanceof ActionChain) {
                eobj = eobj.eContainer();
            }
            if (eobj instanceof ActionChain && eobj.eContainer() instanceof Transition) {
                eobj = eobj.eContainer();
            }
            if (eobj instanceof ActionCode && eobj.eContainer() instanceof Operation) {
                eobj = eobj.eContainer();
            }
            UserEditableRegion.Label label = this.getLabel(eobj);
            IFile file = this.getFile((NamedElement)eobj);
            EditorUtil.openEditor((IFile)file, (UserEditableRegion.Label)label, (MultiStatus)rc);
        }
        return null;
    }

    public IFile getFile(NamedElement element) {
        IProject project = UMLRTGenerator.getInstance().getProject((EObject)element);
        Entity entity = null;
        NamedElement container = element;
        while (container != null) {
            if (container instanceof Entity && !(container instanceof StateMachine)) {
                entity = (Entity)container;
                break;
            }
            container = container.eContainer();
        }
        if (entity != null) {
            IFolder srcFolder = project.getFolder("src");
            return srcFolder.getFile(String.valueOf(entity.getName()) + ".cc");
        }
        return null;
    }

    public UserEditableRegion.Label getLabel(EObject context) {
        EObject container = context.eContainer();
        UserEditableRegion.Label label = new UserEditableRegion.Label();
        label.setQualifiedName(this.getParentQualifiedName(context));
        if (context instanceof Transition) {
            label.setType(UMLPackage.Literals.TRANSITION.getName().toLowerCase());
            label.setDetails(this.getDetails((Transition)context));
        } else if (context instanceof Guard) {
            label.setType(UMLPackage.Literals.TRANSITION__GUARD.getName().toLowerCase());
            label.setDetails(this.getDetails((Transition)container));
        } else if (context instanceof Operation) {
            label.setType(UMLPackage.Literals.OPERATION.getName().toLowerCase());
            label.setDetails(((Operation)context).getName());
        } else if (context instanceof EntryAction) {
            label.setType(UMLPackage.Literals.STATE__ENTRY.getName());
        } else if (context instanceof ExitAction) {
            label.setType(UMLPackage.Literals.STATE__EXIT.getName());
        } else {
            label.setType(UMLPackage.Literals.CLASS.getName());
        }
        label.setUri(context.eResource().getURI().toString());
        return label;
    }

    public String getDetails(Transition transition) {
        String sourceQname = EditSourceHandler.getSMQualifiedName((EObject)transition.getSourceVertex());
        String targetQname = EditSourceHandler.getSMQualifiedName((EObject)transition.getTargetVertex());
        UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(sourceQname, targetQname);
        for (Trigger t : transition.getTriggers()) {
            if (!(t instanceof RTTrigger)) continue;
            RTTrigger trigger = (RTTrigger)t;
            ArrayList<String> ports = new ArrayList<String>();
            for (RTPort p : trigger.getPorts()) {
                ports.add(p.getName());
            }
            details.addTriggerDetail(trigger.getSignal().getName(), ports);
        }
        return details.getTagString();
    }

    public static String getSMQualifiedName(EObject eObject) {
        String result = "";
        EObject container = eObject;
        while (container != null && !(container.eContainer() instanceof StateMachine)) {
            if (container instanceof Vertex) {
                if (result.length() != 0) {
                    result = "::" + result;
                }
                result = String.valueOf(((Vertex)container).getName()) + result;
            }
            container = container.eContainer();
        }
        return result;
    }

    public String getParentQualifiedName(EObject object) {
        ArrayList<String> names = new ArrayList<String>();
        EObject container = object.eContainer();
        while (container != null) {
            if (container instanceof State && !(container.eContainer() instanceof StateMachine)) {
                names.add(0, ((State)container).getName());
            } else if (container instanceof Entity) {
                names.add(0, ((Entity)container).getName());
            } else if (container instanceof Package || container instanceof Model) {
                names.add(0, ((NamedElement)container).getName());
            }
            container = container.eContainer();
        }
        return String.join((CharSequence)"::", names);
    }
}

