/*
 * generated by Xtext
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.scoping

import com.google.common.base.Predicate
import com.google.inject.Inject
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.papyrusrt.xtumlrt.common.Capsule
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart
import org.eclipse.papyrusrt.xtumlrt.common.Connector
import org.eclipse.papyrusrt.xtumlrt.common.ConnectorEnd
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeatureKind
import org.eclipse.papyrusrt.xtumlrt.interactions.Interaction
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition
import org.eclipse.papyrusrt.xtumlrt.statemach.Vertex
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTTrigger
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.resource.EObjectDescription
import org.eclipse.xtext.resource.IEObjectDescription
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.scoping.impl.FilteringScope
import org.eclipse.xtext.scoping.impl.SimpleScope

import static extension org.eclipse.papyrusrt.xtumlrt.util.GeneralUtil.*
import static extension org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTStateMachineUtil.*
import static extension org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil.*
import org.eclipse.xtext.naming.IQualifiedNameConverter

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 *
 */
class UmlrtScopeProvider extends AbstractDeclarativeScopeProvider
{
    @Inject IQualifiedNameProvider nameProvider
    @Inject IQualifiedNameConverter nameConverter

    def IScope scope_CapsulePart_type( CapsulePart context, EReference eref )
    {
        val existingScope = delegateGetScope( context , eref )
        val filteredScope =
            new FilteringScope
            (
                existingScope,
                new Predicate<IEObjectDescription>()
                {
                    override apply( IEObjectDescription input )
                    {
                        val eobj = input.EObjectOrProxy
                        eobj != context.eContainer
                    }
                }
            )
        return filteredScope
    }

    def IScope scope_ConnectorEnd_partWithPort( Connector context, EReference eref )
    {
        val elements = (context.owner as Capsule).parts
        Scopes.scopeFor( elements )
    } 

    def IScope scope_ConnectorEnd_partWithPort( ConnectorEnd context, EReference eref )
    {
        val elements = (context.owner.owner as Capsule).parts
        Scopes.scopeFor( elements )
    } 

    def IScope scope_ConnectorEnd_role( ConnectorEnd context, EReference eref )
    {
        val elements = context.partWithPort.type.ports
        Scopes.scopeFor( elements )
    }

    def IScope scope_Transition_sourceVertex( Transition context, EReference eref )
    {
        transition_endpoints( context, eref )
    }

    def IScope scope_Transition_targetVertex( Transition context, EReference eref )
    {
        transition_endpoints( context, eref )
    }

    protected def IScope transition_endpoints( Transition context, EReference eref )
    {
        val elements = context.possibleEndpoints as List<Vertex>
        Scopes.scopeFor( elements )
    }

    def IScope scope_RTTrigger_ports( Transition context, EReference eref )
    {
        val capsule = context.ownerStateMachine?.owner as Capsule
        val elements = capsule.ports
//        aliasedScope( context, eref, elements )
        Scopes.scopeFor( elements )
    }

//    def IScope scope_RTTrigger_ports( RTTrigger context, EReference eref )
//    {
//        val capsule = context.ownerStateMachine?.owner as Capsule
//        val elements = capsule.ports
////        aliasedScope( context, eref, elements )
//        Scopes.scopeFor( elements )
//    }

    def IScope scope_RTTrigger_signal( RTTrigger context, EReference eref )
    {
        val ports = context.ports
        if (ports === null || ports.empty ) return delegateGetScope( context , eref )
        // If other ports are listed and they have different protocols, then they are ignored
        val port = ports.get(0)
        val protocol = port.type
        val messages = protocol.protocolBehaviourFeatures
        val elements =
            if (!port.conjugate) 
                messages.filter[kind == ProtocolBehaviourFeatureKind.IN || kind == ProtocolBehaviourFeatureKind.INOUT]
            else
                messages.filter[kind == ProtocolBehaviourFeatureKind.OUT || kind == ProtocolBehaviourFeatureKind.INOUT]
//        aliasedScope( context, eref, messages )
        Scopes.scopeFor( elements )
    }

    def IScope scope_Lifeline_represents( Interaction context, EReference eref )
    {
        val model = context.root
        val capsules = model.allCapsules
        val parts = capsules.map[ parts ].flatten
        qualifiedNamesScopeFor( context, parts )
    }

    def IScope scope_Message_signature( Interaction context, EReference eref )
    {
        val model = context.root
        val protocols = model.allProtocols
        val messages = protocols.map[ protocolBehaviourFeatures ].flatten
        qualifiedNamesScopeFor( context, messages )
    }

    protected def IScope aliasedScope( EObject context, EReference eref, Iterable<? extends NamedElement> elements )
    {
        val existingScope = delegateGetScope( context , eref )
        val scope = <IEObjectDescription>newArrayList()
        for ( element : elements )
        {
            scope.add
            (
                new AliasedEObjectDescription
                (
                    QualifiedName.create( element.name ), 
                    EObjectDescription.create( nameProvider.getFullyQualifiedName( element ), element )
                )
            )
        }
        return new SimpleScope( existingScope, scope, false )
    }

    protected def IScope aliasedScopeFor( Iterable<? extends NamedElement> elements )
    {
        val scope = <IEObjectDescription>newArrayList()
        for ( element : elements )
        {
            scope.add
            (
                new AliasedEObjectDescription
                (
                    QualifiedName.create( element.name ), 
                    EObjectDescription.create( nameProvider.getFullyQualifiedName( element ), element )
                )
            )
        }
        return new SimpleScope( IScope.NULLSCOPE, scope, false )
    }

    protected def IScope containmentFilteredScope( IScope existingScope, EObject context, EReference eref, Iterable<? extends NamedElement> elements )
    {
        val list = elements.toList
        val filteredScope =
            new FilteringScope
            (
                existingScope,
                new Predicate<IEObjectDescription>()
                {
                    override apply( IEObjectDescription input )
                    {
                        val eobj = input.getEObjectOrProxy()
                        list.contains( eobj )
                    }
                }
            )
        return filteredScope
    }

    protected def IScope containmentFilteredAliasedScope( EObject context, EReference eref, Iterable<? extends NamedElement> elements )
    {
        val aliased = aliasedScope( context, eref, elements )
        containmentFilteredScope( aliased, context, eref, elements )
    }
    
    protected def qualifiedNamesScopeFor( EObject context, Iterable<? extends NamedElement> elements )
    {
        val contextFqn = nameProvider.getFullyQualifiedName( context )
        val contextFqnStr = contextFqn.toString
        val nameComputation = 
        [
            NamedElement element | 
                val elementFqn = nameProvider.getFullyQualifiedName( element )
                val elementFqnStr = elementFqn.toString
                val longestCommonPrefix = longestCommonPrefix( contextFqnStr, elementFqnStr )
                val relativeElementQnStr = elementFqnStr.substring(longestCommonPrefix.length)
                nameConverter.toQualifiedName( relativeElementQnStr )
        ]
        new SimpleScope( IScope.NULLSCOPE, Scopes.scopedElementsFor(elements, nameComputation) )
    }

}
