/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildListComparator;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.build.UMLRTCCNature;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTSUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

public final class ProjectGenerator {
    private static final String TARGET_BUILDER_ID = "org.eclipse.cdt.build.MakeTargetBuilder";
    private static final String ARTIFACT = "org.eclipse.cdt.build.core.buildArtefactType";
    private static final String UMLRTS_ROOT_VAR = "UMLRTS_ROOT";
    private static final String FAILED_TO_CREATE_OUTPUT_PROJECT = "Failed to create output project";

    private ProjectGenerator() {
    }

    public static IProject getOrCreateCPPProject(String projectName, IProgressMonitor progressMonitor) {
        IWorkspace workspace;
        IProject project;
        IProgressMonitor monitor = progressMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((project = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getProject(projectName)).exists()) {
            if (!project.isOpen()) {
                try {
                    project.open(monitor);
                }
                catch (CoreException coreException) {
                    project = null;
                }
            }
        } else {
            try {
                IProjectDescription description = workspace.newProjectDescription(projectName);
                project = CCorePlugin.getDefault().createCDTProject(description, project, monitor);
                ProjectGenerator.setupCPPProject(project, monitor);
                String rtsroot = ProjectGenerator.getUMLRTSRootEnv();
                ProjectGenerator.addIncludePath(project.getName(), rtsroot, "include");
                ProjectGenerator.addTarget(project, "all");
                ProjectGenerator.addTarget(project, "clean");
            }
            catch (CoreException e) {
                CodeGenPlugin.error((Throwable)e);
                project = null;
            }
        }
        return project;
    }

    private static void setupCPPProject(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.cdt.core.ccnature")) {
            CCProjectNature.addCCNature((IProject)project, (IProgressMonitor)monitor);
        }
        MakeProjectNature.addNature((IProject)project, (IProgressMonitor)monitor);
        UMLRTCCNature.addUMLRTCCNature(project, monitor);
        String os = System.getProperty("os.name").toLowerCase();
        Optional<IToolChain> tc = os.startsWith("win") ? ProjectGenerator.getToolChains().stream().filter(t -> "cdt.managedbuild.toolchain.gnu.cygwin.exe.debug".equals(t.getId())).findFirst() : (os.startsWith("mac") ? ProjectGenerator.getToolChains().stream().filter(t -> "cdt.managedbuild.toolchain.gnu.macosx.exe.debug".equals(t.getId())).findFirst() : ProjectGenerator.getToolChains().stream().filter(t -> "cdt.managedbuild.toolchain.gnu.exe.debug".equals(t.getId())).findFirst());
        if (tc.isPresent()) {
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription desc = mngr.createProjectDescription(project, false);
            ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
            IConfiguration[] configurations = ManagedBuildManager.getExtensionConfigurations((IToolChain)tc.get(), (String)ARTIFACT, (String)"org.eclipse.cdt.build.core.buildArtefactType.exe");
            ManagedProject mProj = new ManagedProject((IResource)project, configurations[0].getProjectType());
            info.setManagedProject((IManagedProject)mProj);
            IConfiguration[] iConfigurationArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                Configuration cf = (Configuration)cfg;
                String id = ManagedBuildManager.calculateChildId((String)cf.getId(), null);
                Configuration config = new Configuration(mProj, cf, id, false, true);
                CConfigurationData data = config.getConfigurationData();
                ICConfigurationDescription cfgDes = desc.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
                config.setConfigurationDescription(cfgDes);
                config.exportArtifactInfo();
                IBuilder bld = config.getEditableBuilder();
                if (bld != null) {
                    bld.setManagedBuildOn(true);
                }
                config.setName(cfg.getName());
                config.setArtifactName(mProj.getDefaultArtifactName());
                ++n2;
            }
            mngr.setProjectDescription(project, desc);
        } else {
            ProjectGenerator.setupDefaultCDTProject(project, monitor);
        }
    }

    private static void setupDefaultCDTProject(IProject project, IProgressMonitor monitor) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desc = mngr.createProjectDescription(project, false);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        ManagedProject mProj = new ManagedProject(desc);
        info.setManagedProject((IManagedProject)mProj);
        Configuration cfg = new Configuration(mProj, null, ManagedBuildManager.calculateChildId((String)"0", null), "Default");
        IBuilder bld = cfg.getEditableBuilder();
        if (bld != null) {
            if (bld.isInternalBuilder()) {
                IConfiguration prefCfg = ManagedBuildManager.getPreferenceConfiguration((boolean)false);
                IBuilder prefBuilder = prefCfg.getBuilder();
                cfg.changeBuilder(prefBuilder, ManagedBuildManager.calculateChildId((String)cfg.getId(), null), prefBuilder.getName());
                bld = cfg.getEditableBuilder();
                bld.setBuildPath(null);
            }
            bld.setManagedBuildOn(false);
        } else {
            CodeGenPlugin.error((String)FAILED_TO_CREATE_OUTPUT_PROJECT);
        }
        cfg.setArtifactName(mProj.getDefaultArtifactName());
        CConfigurationData data = cfg.getConfigurationData();
        desc.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
        mngr.setProjectDescription(project, desc);
    }

    private static List<IToolChain> getToolChains() {
        IBuildPropertyManager bpm = ManagedBuildManager.getBuildPropertyManager();
        IBuildPropertyType bpt = bpm.getPropertyType(ARTIFACT);
        IBuildPropertyValue[] vs = bpt.getSupportedValues();
        Arrays.sort(vs, BuildListComparator.getInstance());
        ArrayList<IToolChain> toolchains = new ArrayList<IToolChain>();
        int i = 0;
        while (i < vs.length) {
            IToolChain[] tcs = ManagedBuildManager.getExtensionsToolChains((String)ARTIFACT, (String)vs[i].getId(), (boolean)false);
            if (tcs != null && tcs.length != 0) {
                toolchains.addAll(Stream.of(tcs).filter(tc -> ManagedBuildManager.isPlatformOk((IToolChain)tc)).collect(Collectors.toList()));
            }
            ++i;
        }
        SortedMap sm = ManagedBuildManager.getExtensionProjectTypeMap();
        for (String s : sm.keySet()) {
            String nattr;
            IProjectType pt = (IProjectType)sm.get(s);
            if (pt.isAbstract() || pt.isSystemObject() || (nattr = pt.getNameAttribute()) == null || nattr.length() == 0) continue;
            IToolChain[] tcs = ManagedBuildManager.getExtensionToolChains((IProjectType)pt);
            toolchains.addAll(Stream.of(tcs).filter(tc -> ManagedBuildManager.isPlatformOk((IToolChain)tc)).collect(Collectors.toList()));
        }
        return toolchains;
    }

    public static void addTarget(IProject project, String targetName) throws CoreException {
        IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
        IMakeTarget newTarget = manager.createTarget(project, targetName, TARGET_BUILDER_ID);
        newTarget.setStopOnError(true);
        newTarget.setRunAllBuilders(false);
        newTarget.setBuildAttribute(IMakeTarget.BUILD_TARGET, targetName);
        newTarget.setUseDefaultBuildCmd(true);
        IFolder container = project.getFolder("src");
        IMakeTarget target = manager.findTarget((IContainer)container, targetName);
        if (target == null) {
            manager.addTarget((IContainer)container, newTarget);
        }
    }

    public static String getUMLRTSRootEnv() {
        String result = "";
        IEnvironmentVariable var = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment().getVariable(UMLRTS_ROOT_VAR, null);
        if (var != null) {
            result = var.getValue();
        }
        if (UMLUtil.isEmpty((String)result)) {
            String rtsroot = System.getenv(UMLRTS_ROOT_VAR);
            result = UMLUtil.isEmpty((String)rtsroot) ? UMLRTSUtil.getRTSRootPath() : "${UMLRTS_ROOT}";
        }
        return result;
    }

    public static void addIncludePath(String targetProjectName, String basePath, String path) throws CoreException {
        ICModel cModel = CoreModel.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        ICProject cProject = cModel.getCProject(targetProjectName);
        if (!cProject.exists()) {
            return;
        }
        if (CoreModel.getDefault().isNewStyleProject(cProject.getProject())) {
            ICConfigurationDescription[] configurations;
            IProject project = cProject.getProject();
            String wsPath = new Path(basePath).makeAbsolute().append(path).toString();
            ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations = projectDescription.getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSetting[] languageSettings;
                ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                ICLanguageSetting[] iCLanguageSettingArray = languageSettings = config.getRootFolderDescription().getLanguageSettings();
                int n3 = languageSettings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSetting langSetting = iCLanguageSettingArray[n4];
                    if (Arrays.asList(langSetting.getSourceContentTypeIds()).contains("org.eclipse.cdt.core.cxxSource")) {
                        ICLanguageSettingEntry[] entries = langSetting.getSettingEntries(1);
                        ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>(Arrays.asList(entries));
                        list.add((ICLanguageSettingEntry)CDataUtil.createCIncludePathEntry((String)wsPath, (int)3));
                        langSetting.setSettingEntries(1, list.toArray(new ICLanguageSettingEntry[list.size()]));
                    }
                    ++n4;
                }
                ++n2;
            }
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
        }
    }
}

