/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.statemach.CompositeState;
import org.eclipse.papyrusrt.xtumlrt.statemach.EntryPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.ExitPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.JunctionPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.Vertex;
import org.eclipse.papyrusrt.xtumlrt.trans.TransformValidator;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtTranslator;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PostUML2xtumlrtValidator
implements TransformValidator<EObject> {
    private UML2xtumlrtTranslator translator;

    public PostUML2xtumlrtValidator(UML2xtumlrtTranslator translator) {
        this.translator = translator;
    }

    public MultiStatus validate(EObject element) {
        MultiStatus _xblockexpression = null;
        final MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
        TreeIterator _eAllContents = element.eAllContents();
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                PostUML2xtumlrtValidator.this.validateGeneratedElement(it, status);
            }
        };
        IteratorExtensions.forEach((Iterator)_eAllContents, (Procedures.Procedure1)_function);
        _xblockexpression = status;
        return _xblockexpression;
    }

    protected void validateGeneratedElement(EObject o, MultiStatus result) {
        Element source;
        if (o instanceof CommonElement && (source = this.translator.getSource((CommonElement)o)) != null) {
            this.validateElement(o, (EObject)source, result);
        }
    }

    protected void _validateElement(EObject o, EObject source, MultiStatus result) {
    }

    protected void _validateElement(JunctionPoint junction, EObject source, MultiStatus result) {
        boolean _notEquals;
        EList _outgoingTransitions = junction.getOutgoingTransitions();
        int _size = _outgoingTransitions.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            Element _source = this.translator.getSource((CommonElement)junction);
            String _qualifiedName = ((Pseudostate)_source).getQualifiedName();
            String _plus = "Junction point " + _qualifiedName;
            String _plus_1 = String.valueOf(_plus) + " must have exactly one outgoing transition";
            DetailedException exception = new DetailedException(_plus_1);
            String _message = exception.getMessage();
            Status status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
            result.add((IStatus)status);
        }
    }

    protected void _validateElement(org.eclipse.papyrusrt.xtumlrt.statemach.Transition t, EObject source, MultiStatus result) {
        Vertex targetNode;
        boolean _tripleEquals;
        Element _source = this.translator.getSource((CommonElement)t);
        boolean bl = _tripleEquals = _source == null;
        if (_tripleEquals) {
            return;
        }
        EObject transitionOwner = t.eContainer();
        Element _source_1 = this.translator.getSource((CommonElement)t);
        String qn = ((Transition)_source_1).getQualifiedName();
        Vertex sourceNode = t.getSourceVertex();
        if (sourceNode instanceof EntryPoint || sourceNode instanceof ExitPoint) {
            EObject _eContainer = sourceNode.eContainer();
            sourceNode = _eContainer;
        }
        if ((targetNode = t.getTargetVertex()) instanceof EntryPoint || targetNode instanceof ExitPoint) {
            EObject _eContainer_1 = sourceNode.eContainer();
            targetNode = _eContainer_1;
        }
        Throwable exception = null;
        if (sourceNode instanceof CompositeState && Objects.equal((Object)sourceNode, (Object)targetNode)) {
            if (t.getSourceVertex() instanceof EntryPoint || t.getTargetVertex() instanceof ExitPoint) {
                if (targetNode != transitionOwner) {
                    DetailedException _detailedException = new DetailedException("Through transition " + qn + " must have same owner state as source and target vertex");
                    exception = _detailedException;
                }
            } else if (targetNode != transitionOwner && targetNode.eContainer() != transitionOwner) {
                DetailedException _detailedException_1 = new DetailedException("Transition " + qn + " does not belong to correct state");
                exception = _detailedException_1;
            }
        } else if (t.getSourceVertex() instanceof EntryPoint || sourceNode == targetNode.eContainer()) {
            if (sourceNode != transitionOwner) {
                DetailedException _detailedException_2 = new DetailedException("Entering transition " + qn + " must have same owner state as target vertex");
                exception = _detailedException_2;
            }
        } else if (t.getTargetVertex() instanceof ExitPoint || targetNode == sourceNode.eContainer()) {
            if (targetNode != transitionOwner) {
                DetailedException _detailedException_3 = new DetailedException("Exiting transition " + qn + " must have same owner state as source vertex");
                exception = _detailedException_3;
            }
        } else {
            EObject _eContainer_3;
            EObject _eContainer_2 = sourceNode.eContainer();
            boolean _equals = Objects.equal((Object)_eContainer_2, (Object)(_eContainer_3 = targetNode.eContainer()));
            if (_equals) {
                boolean _tripleNotEquals;
                EObject _eContainer_4 = targetNode.eContainer();
                boolean bl2 = _tripleNotEquals = _eContainer_4 != transitionOwner;
                if (_tripleNotEquals) {
                    DetailedException _detailedException_4 = new DetailedException("Sibling transition " + qn + " must have same owner state with its vertices if the source and target has same state");
                    exception = _detailedException_4;
                }
            }
        }
        if (exception != null) {
            String _message = exception.getMessage();
            Status status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, exception);
            result.add((IStatus)status);
        }
    }

    protected void _validateElement(final org.eclipse.papyrusrt.xtumlrt.common.Port port, EObject source, MultiStatus result) {
        Functions.Function1<org.eclipse.papyrusrt.xtumlrt.common.Port, Boolean> _function;
        Iterable allParentPorts;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)port);
        Capsule capsule = (Capsule)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Capsule && (_exists = IterableExtensions.exists((Iterable)(allParentPorts = XTUMLRTUtil.getAllRTPorts((Capsule)((Capsule)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<org.eclipse.papyrusrt.xtumlrt.common.Port, Boolean>(){

            public Boolean apply(org.eclipse.papyrusrt.xtumlrt.common.Port it) {
                return Objects.equal((Object)it.getName(), (Object)port.getName()) && port.getRedefines() != it;
            }
        })))) {
            Element _source = this.translator.getSource((CommonElement)port);
            String qn = ((Port)_source).getQualifiedName();
            DetailedException exception = new DetailedException("Port " + qn + " has the same name as a port in the parent capsule but it does not redefine it");
            String _message = exception.getMessage();
            Status status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
            result.add((IStatus)status);
        }
    }

    protected void _validateElement(final CapsulePart part, EObject source, MultiStatus result) {
        Functions.Function1<CapsulePart, Boolean> _function;
        Iterable allParentParts;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)part);
        Capsule capsule = (Capsule)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Capsule && (_exists = IterableExtensions.exists((Iterable)(allParentParts = XTUMLRTUtil.getAllCapsuleParts((Capsule)((Capsule)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return Objects.equal((Object)it.getName(), (Object)part.getName()) && part.getRedefines() != it;
            }
        })))) {
            Element _source = this.translator.getSource((CommonElement)part);
            String qn = ((Property)_source).getQualifiedName();
            DetailedException exception = new DetailedException("Part " + qn + " has the same name as a part in the parent capsule but it does not redefine it");
            String _message = exception.getMessage();
            Status status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
            result.add((IStatus)status);
        }
    }

    protected void _validateElement(final Connector conn, EObject source, MultiStatus result) {
        Functions.Function1<Connector, Boolean> _function;
        Iterable allParentParts;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)conn);
        Capsule capsule = (Capsule)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Capsule && (_exists = IterableExtensions.exists((Iterable)(allParentParts = XTUMLRTUtil.getAllConnectors((Capsule)((Capsule)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                return Objects.equal((Object)it.getName(), (Object)conn.getName()) && conn.getRedefines() != it;
            }
        })))) {
            Element _source = this.translator.getSource((CommonElement)conn);
            String qn = ((Property)_source).getQualifiedName();
            DetailedException exception = new DetailedException("Connector " + qn + " has the same name as a connector in the parent capsule but it does not redefine it");
            String _message = exception.getMessage();
            Status status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
            result.add((IStatus)status);
        }
    }

    protected void validateElement(EObject junction, EObject source, MultiStatus result) {
        if (junction instanceof JunctionPoint) {
            this._validateElement((JunctionPoint)junction, source, result);
            return;
        }
        if (junction instanceof CapsulePart) {
            this._validateElement((CapsulePart)junction, source, result);
            return;
        }
        if (junction instanceof Connector) {
            this._validateElement((Connector)junction, source, result);
            return;
        }
        if (junction instanceof org.eclipse.papyrusrt.xtumlrt.common.Port) {
            this._validateElement((org.eclipse.papyrusrt.xtumlrt.common.Port)junction, source, result);
            return;
        }
        if (junction instanceof org.eclipse.papyrusrt.xtumlrt.statemach.Transition) {
            this._validateElement((org.eclipse.papyrusrt.xtumlrt.statemach.Transition)junction, source, result);
            return;
        }
        if (junction != null) {
            this._validateElement(junction, source, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(junction, source, result).toString());
    }
}

