/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.trans.TransformValidator;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PreUML2xtumlrtValidator
implements TransformValidator<List<EObject>> {
    public MultiStatus validate(List<EObject> context) {
        MultiStatus _xblockexpression = null;
        final MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
        for (EObject e : context) {
            TreeIterator _eAllContents = e.eAllContents();
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                    PreUML2xtumlrtValidator.this.validateElement(it, status);
                }
            };
            IteratorExtensions.forEach((Iterator)_eAllContents, (Procedures.Procedure1)_function);
        }
        _xblockexpression = status;
        return _xblockexpression;
    }

    protected void _validateElement(EObject e, MultiStatus result) {
    }

    protected void _validateElement(Constraint o, MultiStatus result) {
        ValueSpecification spec = o.getSpecification();
        if (spec == null) {
            String qualifiedName = this.getValidQualifiedName((EObject)o);
            Status status = this.createStatus("OpaqueExpression " + qualifiedName + " must have C++ specification");
            result.add((IStatus)status);
        } else {
            this.validateElement((EObject)spec, result);
        }
    }

    protected void _validateElement(MultiplicityElement element, MultiStatus result) {
        ValueSpecification upper;
        ValueSpecification lower = element.getLowerValue();
        if (lower != null) {
            this.validateElement((EObject)lower, result);
        }
        if ((upper = element.getUpperValue()) != null) {
            this.validateElement((EObject)upper, result);
        }
    }

    protected void _validateElement(OpaqueExpression opaque, MultiStatus result) {
        boolean found = false;
        int i = 0;
        while (i < opaque.getLanguages().size()) {
            if ("C++".equals(opaque.getLanguages().get(i)) && opaque.getBodies().get(i) != null) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            String qualifiedName = this.getValidQualifiedName((EObject)opaque);
            Status status = this.createStatus("Element " + qualifiedName + " must have specification for C++ language");
            result.add((IStatus)status);
        }
    }

    protected Status createStatus(String msg) {
        Status status;
        Status _xblockexpression = null;
        DetailedException exception = new DetailedException(msg);
        String _message = exception.getMessage();
        _xblockexpression = status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
        return _xblockexpression;
    }

    protected String getValidQualifiedName(EObject context) {
        String _xblockexpression = null;
        String qualifiedName = "";
        EObject container = context;
        while (UMLUtil.isEmpty((String)qualifiedName)) {
            EObject _eContainer;
            if (container instanceof NamedElement) {
                String _qualifiedName;
                qualifiedName = _qualifiedName = ((NamedElement)container).getQualifiedName();
            }
            container = _eContainer = container.eContainer();
        }
        _xblockexpression = qualifiedName;
        return _xblockexpression;
    }

    protected void validateElement(EObject opaque, MultiStatus result) {
        if (opaque instanceof OpaqueExpression) {
            this._validateElement((OpaqueExpression)opaque, result);
            return;
        }
        if (opaque instanceof Constraint) {
            this._validateElement((Constraint)opaque, result);
            return;
        }
        if (opaque instanceof MultiplicityElement) {
            this._validateElement((MultiplicityElement)opaque, result);
            return;
        }
        if (opaque != null) {
            this._validateElement(opaque, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(opaque, result).toString());
    }
}

