/*******************************************************************************
 * Copyright (c) 2017 Zeligsoft (2009) Limited  and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/

package org.eclipse.papyrusrt.codegen.cpp.validation

import java.util.List
import org.eclipse.core.runtime.IStatus
import org.eclipse.core.runtime.MultiStatus
import org.eclipse.core.runtime.Status
import org.eclipse.emf.ecore.EObject
import org.eclipse.papyrusrt.codegen.CodeGenPlugin
import org.eclipse.papyrusrt.xtumlrt.trans.TransformValidator
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException
import org.eclipse.uml2.uml.Constraint
import org.eclipse.uml2.uml.MultiplicityElement
import org.eclipse.uml2.uml.NamedElement
import org.eclipse.uml2.uml.OpaqueExpression
import org.eclipse.uml2.uml.util.UMLUtil

/**
 * Pre UML2xtumlrt validation
 * @author ysroh
 * 
 */
class PreUML2xtumlrtValidator implements TransformValidator<List<EObject>> {

	override MultiStatus validate(List<EObject> context) {
		val status = new MultiStatus(CodeGenPlugin.ID, IStatus.INFO, "UML-RT Code Generator Invoked", null)
		for (e : context) {
			e.eAllContents.forEach[validateElement(status)]
		}
		status
	}

	protected dispatch def void validateElement(EObject e, MultiStatus result) {
	}

	protected dispatch def void validateElement(Constraint o, MultiStatus result) {
		val spec = o.specification
		if (spec === null) {
			var qualifiedName = o.validQualifiedName
			val status = createStatus("OpaqueExpression " + qualifiedName + " must have C++ specification")
			result.add(status)
		} else {
			spec.validateElement(result)
		}
	}

	protected dispatch def void validateElement(MultiplicityElement element, MultiStatus result) {
		val lower = element.lowerValue
		if (lower !== null) {
			lower.validateElement(result)
		}
		val upper = element.upperValue
		if (upper !== null) {
			upper.validateElement(result)
		}
	}

	protected dispatch def void validateElement(OpaqueExpression opaque, MultiStatus result) {
		var found = false;
		var index = 0;
		for (var i = 0; i < opaque.languages.size; i++) {
			if ("C++".equals(opaque.languages.get(i)) && opaque.bodies.get(i) !== null) {
				found = true
			}
			index++
		}
		if (!found) {
			var qualifiedName = opaque.validQualifiedName
			val status = createStatus("Element " + qualifiedName + " must have specification for C++ language")
			result.add(status)
		}
	}

	protected def Status createStatus(String msg) {
		val exception = new DetailedException(msg)
		val status = new Status(IStatus.ERROR, CodeGenPlugin.ID, exception.message, exception)
		status
	}

	protected def String getValidQualifiedName(EObject context) {
		var qualifiedName = ""
		var container = context
		while (UMLUtil.isEmpty(qualifiedName)) {
			if (container instanceof NamedElement) {
				qualifiedName = (container as NamedElement).qualifiedName
			}
			container = container.eContainer
		}
		qualifiedName
	}

}
