/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.language;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.core.resources.ResourceHelperImpl;
import org.eclipse.papyrus.infra.core.language.Language;
import org.eclipse.papyrus.infra.core.language.Version;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTResourcesUtil;

public class UMLRTLanguage
extends Language {
    public static final String UMLRT_LANGUAGE_ID = "org.eclipse.papyrusrt.umlrt.core.language";
    private TransactionalEditingDomainListener transactionListener;

    public UMLRTLanguage() {
        super(UMLRT_LANGUAGE_ID, new Version(1, 1, 0), "UML Real-Time");
    }

    public void install(ModelSet modelSet) {
        UMLRTResourcesUtil.installUMLRTFactory((ResourceSet)modelSet);
        UMLRTResourcesUtil.initLocalStereotypeApplicationHelper((ResourceSet)modelSet);
        UMLRTResourcesUtil.setUndoRedoQuery((ResourceSet)modelSet, () -> UMLRTCommandUtils.isUndoRedoInProgress((Notifier)modelSet));
        this.installResourceHelper(modelSet);
        TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)modelSet.getTransactionalEditingDomain(), TransactionalEditingDomain.Lifecycle.class);
        if (lifecycle != null) {
            this.initializeUndoRedo(lifecycle);
        }
    }

    private void installResourceHelper(final ModelSet modelSet) {
        modelSet.eAdapters().add((Object)new ResourceHelperImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getNotifier() instanceof ResourceSet && msg.getFeatureID(ResourceSet.class) == 0) {
                    switch (msg.getEventType()) {
                        case 3: {
                            ((Resource)msg.getNewValue()).eAdapters().add((Object)this);
                            break;
                        }
                        case 5: {
                            ((Collection)msg.getNewValue()).forEach(r -> {
                                boolean bl = ((Resource)r).eAdapters().add((Object)this);
                            });
                            break;
                        }
                        case 4: {
                            ((Resource)msg.getOldValue()).eAdapters().remove((Object)this);
                            break;
                        }
                        case 6: {
                            ((Collection)msg.getOldValue()).forEach(r -> {
                                boolean bl = ((Resource)r).eAdapters().remove((Object)this);
                            });
                            break;
                        }
                        case 1: {
                            ((Resource)msg.getNewValue()).eAdapters().add((Object)this);
                            ((Resource)msg.getOldValue()).eAdapters().remove((Object)this);
                        }
                    }
                }
            }

            public EObject create(EClass eClass) {
                EPackage package_ = eClass.getEPackage();
                EFactory factory = modelSet.getPackageRegistry().getEFactory(package_.getNsURI());
                if (factory == null) {
                    factory = package_.getEFactoryInstance();
                }
                return factory.create(eClass);
            }
        });
    }

    private void initializeUndoRedo(TransactionalEditingDomain.Lifecycle domainLifecycle) {
        this.transactionListener = new TransactionalEditingDomainListenerImpl(){

            public void transactionStarted(TransactionalEditingDomainEvent event) {
                ReificationAdapter reifier;
                if (this.isUndoRedoTransaction(event) && (reifier = ReificationAdapter.getInstance((ResourceSet)event.getSource().getResourceSet())) != null) {
                    reifier.disableAutoReification();
                }
            }

            public void transactionClosed(TransactionalEditingDomainEvent event) {
                ReificationAdapter reifier;
                if (this.isUndoRedoTransaction(event) && (reifier = ReificationAdapter.getInstance((ResourceSet)event.getSource().getResourceSet())) != null) {
                    reifier.enableAutoReification();
                }
            }

            private boolean isUndoRedoTransaction(TransactionalEditingDomainEvent event) {
                Transaction transaction = event.getTransaction();
                return transaction != null && Boolean.TRUE.equals(transaction.getOptions().get("is_undo_redo_transaction"));
            }
        };
        domainLifecycle.addTransactionalEditingDomainListener(this.transactionListener);
    }

    public void uninstall(ModelSet modelSet) {
        if (this.transactionListener != null) {
            TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)modelSet.getTransactionalEditingDomain(), TransactionalEditingDomain.Lifecycle.class);
            if (lifecycle != null) {
                lifecycle.removeTransactionalEditingDomainListener(this.transactionListener);
            }
            this.transactionListener = null;
        }
        UMLRTResourcesUtil.uninstallUMLRTFactory((ResourceSet)modelSet);
    }
}

