/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.types.advice;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTClassifier;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTSwitch;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

public class DeleteRedefinitionsAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        UMLRTNamedElement rt;
        ICommand result = null;
        EObject destructee = request.getElementToDestroy();
        if (destructee instanceof Generalization) {
            result = this.getBeforeDestroyDependentsCommand(request, (Generalization)destructee);
        } else if (destructee instanceof NamedElement && (rt = UMLRTFactory.create((NamedElement)((NamedElement)destructee))) != null) {
            if (rt.isInherited()) {
                if (!this.canDestroy(request, rt)) {
                    result = UnexecutableCommand.INSTANCE;
                }
            } else {
                result = this.getBeforeDestroyDependentsCommand(request, rt);
            }
        }
        return result;
    }

    boolean canDestroy(DestroyDependentsRequest request, UMLRTNamedElement element) {
        boolean result;
        Namespace namespace = element.toUML().getNamespace();
        if (namespace != null && this.isBeingDestroyed(request, (EObject)namespace)) {
            result = true;
        } else {
            UMLRTNamedElement redefined = element.getRedefinedElement();
            if (redefined != null && (this.isBeingDestroyed(request, (EObject)redefined.toUML()) || redefined.toUML() instanceof Behavior)) {
                result = true;
            } else {
                result = true;
                UMLRTNamedElement root = element.getRootDefinition();
                if (root != null) {
                    UMLRTNamedElement redefCtx = element.getRedefinitionContext();
                    UMLRTNamedElement rootCtx = root.getRedefinitionContext();
                    if (redefCtx instanceof UMLRTClassifier && rootCtx instanceof UMLRTClassifier) {
                        UMLRTClassifier supertype = (UMLRTClassifier)rootCtx;
                        UMLRTClassifier subtype = (UMLRTClassifier)redefCtx;
                        if (supertype.isSuperTypeOf(subtype)) {
                            result = this.generalizations(subtype, supertype).anyMatch(g -> this.isBeingDestroyed(request, (EObject)g));
                        }
                    } else if (redefCtx != null && redefCtx.redefines(rootCtx)) {
                        result = redefCtx.getRedefinitionChain().stream().anyMatch(ctx -> this.isBeingDestroyed(request, (EObject)ctx.toUML()));
                    }
                }
            }
        }
        return result;
    }

    boolean isBeingDestroyed(DestroyDependentsRequest request, EObject object) {
        boolean result = false;
        EObject test = object;
        while (!result && test != null) {
            result = request.getElementToDestroy() == test || request.getParameter("DestroyElementRequest.initialElementToDestroy") == test || request.getDependentElementsToDestroy().contains(test);
            test = test.eContainer();
        }
        return result;
    }

    private Stream<Generalization> generalizations(UMLRTClassifier fromClassifier, UMLRTClassifier toClassifier) {
        Stream.Builder<Generalization> result = Stream.builder();
        UMLRTClassifier classifier = fromClassifier;
        while (classifier != null && classifier != toClassifier) {
            UMLRTClassifier supertype = this.getSupertype(classifier);
            if (supertype != null) {
                result.add(classifier.toUML().getGeneralization(supertype.toUML()));
            }
            classifier = supertype;
        }
        return result.build();
    }

    private UMLRTClassifier getSupertype(UMLRTClassifier classifier) {
        UMLRTCapsule result = null;
        if (classifier instanceof UMLRTCapsule) {
            result = ((UMLRTCapsule)classifier).getSuperclass();
        } else if (classifier instanceof UMLRTProtocol) {
            result = ((UMLRTProtocol)classifier).getSuperProtocol();
        }
        return result;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request, Generalization destructee) {
        Optional<UMLRTClassifier> classifier = Optional.ofNullable(UMLRTFactory.create((NamedElement)destructee.getSpecific())).filter(UMLRTClassifier.class::isInstance).map(UMLRTClassifier.class::cast);
        Stream hierarchy = classifier.map(UMLRTClassifier::getHierarchy).orElseGet(Stream::empty);
        Stream<NamedElement> elementsToDestroy = hierarchy.skip(1L).flatMap(this::inheritableMembers).filter(p -> this.inheritsFrom((UMLRTNamedElement)p, (UMLRTClassifier)classifier.get())).map(UMLRTNamedElement::toUML);
        ICommand result = elementsToDestroy.map(arg_0 -> ((DestroyDependentsRequest)request).getDestroyDependentCommand(arg_0)).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
        return result;
    }

    boolean inheritsFrom(UMLRTNamedElement element, UMLRTClassifier classifier) {
        return Optional.ofNullable(element.getInheritedElement()).map(UMLRTNamedElement::getRedefinitionContext).map(UMLRTClassifier.class::cast).map(c -> c.isSuperTypeOf(classifier)).orElse(false);
    }

    Stream<? extends UMLRTNamedElement> inheritableMembers(UMLRTClassifier classifier) {
        return (Stream)new UMLRTSwitch<Stream<? extends UMLRTNamedElement>>(){

            public Stream<? extends UMLRTNamedElement> caseCapsule(UMLRTCapsule object) {
                return Stream.concat(object.getPorts(true).stream(), Stream.concat(object.getCapsuleParts(true).stream(), object.getConnectors(true).stream()));
            }

            public Stream<? extends UMLRTNamedElement> caseProtocol(UMLRTProtocol object) {
                return object.getMessages(true).stream();
            }

            public Stream<? extends UMLRTNamedElement> defaultCase(Object object) {
                return Stream.empty();
            }
        }.doSwitch((Object)classifier);
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request, UMLRTNamedElement destructee) {
        Optional<UMLRTClassifier> classifier = Optional.ofNullable(destructee.getRedefinitionContext()).filter(UMLRTClassifier.class::isInstance).map(UMLRTClassifier.class::cast);
        Stream hierarchy = classifier.map(UMLRTClassifier::getHierarchy).orElseGet(Stream::empty);
        Stream<NamedElement> elementsToDestroy = hierarchy.skip(1L).flatMap(this::inheritableMembers).filter(p -> p.redefines(destructee)).map(UMLRTNamedElement::toUML);
        ICommand result = elementsToDestroy.map(e -> this.getDestroyDependentCommand(request, (EObject)e)).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
        return result;
    }

    protected ICommand getDestroyDependentCommand(DestroyDependentsRequest request, EObject object) {
        ICommand result = request.getDestroyDependentCommand(object);
        if (result == null) {
            DestroyElementRequest destroy = new DestroyElementRequest(request.getEditingDomain(), object, request.isConfirmationRequired());
            destroy.setClientContext(request.getClientContext());
            destroy.addParameters(request.getParameters());
            destroy.setParameter("DestroyElementRequest.destroyDependentsRequest", (Object)request);
            Object eHelperContext = destroy.getEditHelperContext();
            IElementType context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
            if (context != null) {
                result = context.getEditCommand((IEditCommandRequest)destroy);
            }
        }
        return result;
    }
}

