/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.requests.UnsetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public abstract class AbstractRTPseudoStateEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    protected abstract PseudostateKind getKind();

    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        UMLRTVertex vertex;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (request.isExclude() && request.getElementToExclude() instanceof Vertex && (vertex = UMLRTVertex.getInstance((Vertex)((Vertex)request.getElementToExclude()))) != null) {
            ICommand excludeTransitions;
            Predicate<UMLRTNamedElement> alreadyExcluded = UMLRTNamedElement::isExcluded;
            List transitionsToExclude = Stream.concat(vertex.getIncomings().stream(), vertex.getOutgoings().stream()).distinct().filter(alreadyExcluded.negate()).map(UMLRTTransition::toUML).collect(Collectors.toList());
            if (!transitionsToExclude.isEmpty() && (excludeTransitions = request.getExcludeDependentsCommand(transitionsToExclude)) != null) {
                result = CompositeCommand.compose((ICommand)result, (ICommand)excludeTransitions);
            }
        }
        return result;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ConfigureElementCommand command = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
                EObject elementToConfigure = request.getElementToConfigure();
                if (!(elementToConfigure instanceof Pseudostate)) {
                    return CommandResult.newErrorCommandResult((String)"Element to configure is not a pseudostate");
                }
                Pseudostate pseudoState = (Pseudostate)elementToConfigure;
                try {
                    SetRequest setKindRequest = new SetRequest((EObject)pseudoState, (EStructuralFeature)UMLPackage.eINSTANCE.getPseudostate_Kind(), (Object)AbstractRTPseudoStateEditHelperAdvice.this.getKind());
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)pseudoState);
                    if (provider == null) {
                        throw new ExecutionException("Impossible to get the provider from " + pseudoState);
                    }
                    ICommand setKindCommand = provider.getEditCommand((IEditCommandRequest)setKindRequest);
                    if (setKindCommand != null) {
                        if (setKindCommand.canExecute()) {
                            IStatus status = setKindCommand.execute(monitor, info);
                            if (status.isOK()) {
                                return CommandResult.newOKCommandResult((Object)pseudoState);
                            }
                            throw new ExecutionException(status.getMessage());
                        }
                        throw new ExecutionException("Command to set the pseudo state kind is not executable");
                    }
                    throw new ExecutionException("Impossible to find a command to set the kind of the pseudo state");
                }
                catch (ExecutionException e) {
                    return CommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        };
        ICommand superCommand = super.getBeforeConfigureCommand(request);
        if (superCommand != null) {
            return command.compose((IUndoableOperation)superCommand).reduce();
        }
        return command.reduce();
    }

    protected ICommand getAfterConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Pseudostate pseudostate = (Pseudostate)request.getElementToConfigure();
                String name = AbstractRTPseudoStateEditHelperAdvice.this.getInitialName(pseudostate);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)pseudostate);
                if (provider == null) {
                    throw new ExecutionException("Impossible to get the provider from " + pseudostate);
                }
                if (Strings.isNullOrEmpty((String)name) && request.getParameter("nameToSet") != null) {
                    UnsetRequest unsetRequest = new UnsetRequest((EObject)pseudostate, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__NAME);
                    ICommand resetNameCommand = provider.getEditCommand((IEditCommandRequest)unsetRequest);
                    if (resetNameCommand != null && resetNameCommand.canExecute()) {
                        resetNameCommand.execute(progressMonitor, info);
                    }
                } else {
                    SetRequest setNameRequest = new SetRequest((EObject)pseudostate, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)name);
                    ICommand setNameCommand = provider.getEditCommand((IEditCommandRequest)setNameRequest);
                    if (setNameCommand != null && setNameCommand.canExecute()) {
                        setNameCommand.execute(progressMonitor, info);
                    }
                }
                return CommandResult.newOKCommandResult((Object)pseudostate);
            }
        };
    }

    protected String getInitialName(Pseudostate pseudostate) {
        switch (pseudostate.getKind()) {
            // Empty switch
        }
        String result = null;
        return result;
    }
}

