/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTProfileUtils
extends UMLUtil {
    public static boolean isUMLRTProfileApplied(Element element) {
        Package package_ = element.getNearestPackage();
        if (package_ == null) {
            return false;
        }
        for (Profile profile : package_.getAllAppliedProfiles()) {
            if (!"http://www.eclipse.org/papyrus/umlrt".equals(profile.getURI())) continue;
            return true;
        }
        return false;
    }

    public static Stereotype getApplicableStereotype(Element context, EClass ecoreDefinition) {
        Stereotype result = (Stereotype)UMLRTProfileUtils.getNamedElement((ENamedElement)ecoreDefinition, (EObject)context);
        if (result != null && !context.isStereotypeApplicable(result)) {
            result = null;
        }
        return result;
    }

    public static <E extends Element> E ensureStereotype(E element, EClass stereotype) {
        Stereotype rt = UMLRTProfileUtils.getApplicableStereotype(element, stereotype);
        if (rt != null && !element.isStereotypeApplied(rt)) {
            element.applyStereotype(rt);
        }
        return element;
    }

    public static boolean canExclude(Element element) {
        boolean result;
        UMLRTInheritanceKind inheritance = UMLRTInheritanceKind.of((Element)element);
        switch (inheritance) {
            case INHERITED: 
            case REDEFINED: {
                result = !(element instanceof Pseudostate) && !(element instanceof Constraint) && element.eContainmentFeature() != UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static boolean canReinherit(Element element) {
        boolean result;
        UMLRTInheritanceKind inheritance = UMLRTInheritanceKind.of((Element)element);
        switch (inheritance) {
            case REDEFINED: 
            case EXCLUDED: {
                result = element.eContainmentFeature() != UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

