/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import java.util.Optional;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeNameEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.PortContainerEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;

public class RTClassCompositeEditPart
extends ClassCompositeEditPart
implements IInheritableEditPart {
    public RTClassCompositeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new PortContainerEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ClassCompositeNameEditPart) {
            ((ClassCompositeNameEditPart)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof ClassCompositeCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getCompositeCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((ClassCompositeCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (IRTPortEditPart.isPortOnCapsule(childEditPart)) {
            IRTPortEditPart port = (IRTPortEditPart)childEditPart;
            if (this.hasNotationView() && this.getNotationView().isSetElement()) {
                RTPortPositionLocator locator = new RTPortPositionLocator((Element)port.getPort(), this.getMainFigure(), 0, port.getDefaultScaleFactor());
                this.getBorderedFigure().getBorderItemContainer().add(port.getFigure(), (Object)locator);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canInherit() {
        Class class_ = (Class)TypeUtils.as((Object)this.resolveSemanticElement(), Class.class);
        return Optional.ofNullable(class_).map(UMLRTCapsule::getInstance).map(UMLRTCapsule::getSuperclass).isPresent();
    }

    @Override
    public View getRedefinedView() {
        View result = null;
        if (this.isInherited()) {
            Class class_ = (Class)TypeUtils.as((Object)this.resolveSemanticElement(), Class.class);
            result = Optional.ofNullable(class_).map(UMLRTCapsule::getInstance).map(UMLRTCapsule::getSuperclass).map(UMLRTCapsule::toUML).map(UMLRTCapsuleStructureDiagramUtils::getCapsuleStructureDiagram).map(d -> UMLRTEditPartUtils.findView((View)d, "Class_Shape", d.getElement())).orElse(null);
        }
        return result;
    }
}

