/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.types.advice;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;

public class DeleteInheritedViewsAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ICommand result = null;
        EObject destructee = request.getElementToDestroy();
        if (destructee instanceof Element) {
            result = this.getBeforeDestroyDependentsCommand(request, (Element)destructee);
        }
        return result;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request, Element destructee) {
        Optional<Element> inherited = Optional.of(destructee).map(UMLRTExtensionUtil::getRootDefinition);
        Stream<Object> views = inherited.map(this::getViews).orElseGet(Stream::empty).filter(v -> {
            EObject semantic = EditPartInheritanceUtils.resolveSemanticElement(v);
            return semantic != destructee && semantic instanceof Element && UMLRTExtensionUtil.redefines((Element)((Element)semantic), (Element)destructee);
        });
        List views_ = views.collect(Collectors.toList());
        views = views_.stream();
        ICommand result = views.map(arg_0 -> ((DestroyDependentsRequest)request).getDestroyDependentCommand(arg_0)).filter(Objects::nonNull).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
        return result;
    }

    Stream<View> getViews(Element element) {
        return EMFHelper.getUsages((EObject)element).stream().filter(s -> s.getEStructuralFeature() == NotationPackage.Literals.VIEW__ELEMENT).map(EStructuralFeature.Setting::getEObject).map(View.class::cast).filter(v -> v.eResource() != null);
    }
}

