/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;

public class RelativePortLocationHelper {
    private final IGraphicalEditPart editPart;
    private final Map<IGraphicalEditPart, RelativePortLocation> ports = new HashMap<IGraphicalEditPart, RelativePortLocation>();

    public RelativePortLocationHelper(EditPart editPart) {
        this.editPart = (IGraphicalEditPart)editPart;
    }

    private Rectangle getBounds(IGraphicalEditPart editPart) {
        Rectangle result;
        Bounds constraint = this.getNotationBounds(editPart);
        if (constraint == null) {
            result = editPart.getFigure().getBounds();
        } else if (constraint.getWidth() <= 0 || constraint.getHeight() <= 0) {
            Dimension size = editPart.getFigure().getSize();
            result = new Rectangle(constraint.getX(), constraint.getY(), size.width(), size.height());
        } else {
            result = new Rectangle(constraint.getX(), constraint.getY(), constraint.getWidth(), constraint.getHeight());
        }
        if (result.width() <= 0 || result.height() <= 0) {
            result = new Rectangle(result.getLocation(), editPart.getFigure().getPreferredSize());
        }
        return result;
    }

    private Bounds getNotationBounds(IGraphicalEditPart gep) {
        Bounds result = null;
        Node node = (Node)TypeUtils.as((Object)gep.getNotationView(), Node.class);
        if (node != null) {
            result = (Bounds)TypeUtils.as((Object)node.getLayoutConstraint(), Bounds.class);
        }
        return result;
    }

    private Rectangle getHostBounds() {
        return this.getBounds(this.editPart);
    }

    public void memoizeRelativePortLocation(EditPart port, Bounds definingPortBounds, Bounds capsuleBounds) {
        RelativePortLocation location = RelativePortLocation.of(definingPortBounds, capsuleBounds);
        if (location != null) {
            this.ports.put((IGraphicalEditPart)port, location);
        }
    }

    public void memoizeRelativePortLocation(EditPart port) {
        IGraphicalEditPart editPart = (IGraphicalEditPart)port;
        RelativePortLocation location = RelativePortLocation.of(this.getBounds(editPart), this.getHostBounds());
        if (location != null) {
            this.ports.put(editPart, location);
        }
    }

    public void addAllPorts(RelativePortLocationHelper other) {
        if (other.editPart != this.editPart) {
            throw new IllegalArgumentException("other is owned by a different edit-part");
        }
        this.ports.putAll(other.ports);
    }

    public Command getPortUpdateCommand(ChangeBoundsRequest request) {
        return this.getPortUpdateCommand(request.getTransformedRectangle(this.getHostBounds()));
    }

    public Command getPortUpdateCommand() {
        return this.getPortUpdateCommand(this.getHostBounds());
    }

    private Command getPortUpdateCommand(Rectangle bounds) {
        CompoundCommand result = new CompoundCommand("Update Port Locations");
        this.ports.forEach((port, location) -> {
            Rectangle portBounds = this.getBounds((IGraphicalEditPart)port);
            Point moveTo = location.applyTo(bounds, portBounds.getSize());
            SetBoundsCommand move = new SetBoundsCommand(this.editPart.getEditingDomain(), "Place Port", (IAdaptable)new EObjectAdapter((EObject)port.getNotationView()), moveTo);
            result.add((Command)new ICommandProxy((ICommand)move));
        });
        return result.unwrap();
    }

    public void reset() {
        this.ports.clear();
    }

    public Collection<IGraphicalEditPart> getPortEditParts() {
        return Collections.unmodifiableSet(this.ports.keySet());
    }
}

