/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.VisualTypeService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PortPositionEnum;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTLinksLFEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.StateMachineViewUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPartTN;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class RTStateGraphicalNodeEditPolicy
extends RTLinksLFEditPolicy {
    protected void showCreationFeedback(CreateConnectionRequest request) {
        Point p = new Point(request.getLocation());
        EditPart part = this.getHost().getViewer().findObjectAt(p);
        if (part != null) {
            part = part.getTargetEditPart((Request)request);
        }
        IFigure figure = null;
        if (part instanceof RTStateEditPartTN) {
            figure = ((RTStateEditPartTN)part).getBorderedFigure().getMainFigure();
        } else if (part instanceof RTStateEditPart) {
            figure = ((RTStateEditPart)part).getBorderedFigure().getMainFigure();
        }
        if (figure != null) {
            FeedbackHelper helper = this.getFeedbackHelper(request);
            PortPositionLocator locator = new PortPositionLocator(figure);
            locator.setPosition(PortPositionEnum.ONLINE);
            p = locator.getPreferredLocation(new Rectangle(p.x(), p.y(), 0, 0)).getLocation();
            helper.update((ConnectionAnchor)new XYAnchor(p), p);
        } else {
            super.showCreationFeedback(request);
        }
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        Diagram diagramView = ((View)this.getHost().getModel()).getDiagram();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CreateCommand createCommand = new CreateCommand(editingDomain, (CreateViewRequest.ViewDescriptor)req.getConnectionViewDescriptor(), (View)diagramView.getDiagram());
        this.setViewAdapter((IAdaptable)createCommand.getCommandResult().getReturnValue());
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor(this.getViewAdapter());
        if (!UMLRTEditPartUtils.isCanonicalRequest((CreateRequest)req) && StateMachineViewUtils.getTransitionHint().equals(req.getConnectionViewDescriptor().getSemanticHint())) {
            sceCommand.setNewSourceAdaptor(this.getTransitionSourceViewAdapter(request));
        } else {
            sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)this.getView()));
        }
        ConnectionAnchor sourceAnchor = this.getConnectableEditPart().getSourceConnectionAnchor((Request)request);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor(this.getViewAdapter());
        scaCommand.setNewSourceTerminal(this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor));
        SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter(this.getViewAdapter());
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        cc.compose((IUndoableOperation)sbbCommand);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        return c;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((Request)request);
        Iterator commandItr = cc.iterator();
        commandItr.next();
        SetConnectionEndsCommand sceCommand = (SetConnectionEndsCommand)commandItr.next();
        if (!UMLRTEditPartUtils.isCanonicalRequest((CreateRequest)request) && request instanceof CreateConnectionViewRequest && StateMachineViewUtils.getTransitionHint().equals(((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            sceCommand.setNewTargetAdaptor(this.getTransitionTargetViewAdapter(request));
        } else {
            sceCommand.setNewTargetAdaptor((IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)targetEP).getNotationView()));
        }
        SetConnectionAnchorsCommand scaCommand = (SetConnectionAnchorsCommand)commandItr.next();
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        this.setViewAdapter(sceCommand.getEdgeAdaptor());
        INodeEditPart sourceEditPart = (INodeEditPart)request.getSourceEditPart();
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(scaCommand.getNewSourceTerminal());
        PointList pointList = new PointList();
        if (request.getLocation() == null) {
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
        } else {
            pointList.addPoint(sourceAnchor.getLocation(request.getLocation()));
            pointList.addPoint(targetAnchor.getLocation(request.getLocation()));
        }
        SetConnectionBendpointsCommand sbbCommand = (SetConnectionBendpointsCommand)commandItr.next();
        sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
        return request.getStartCommand();
    }

    private IAdaptable getTransitionSourceViewAdapter(CreateConnectionRequest request) {
        return new ExtremityViewAdaptable(request.getLocation(), true);
    }

    private IAdaptable getTransitionTargetViewAdapter(CreateConnectionRequest request) {
        return new ExtremityViewAdaptable(request.getLocation(), false);
    }

    protected View getTransitionExtremityView(boolean isStartEnd, Point location) {
        EObject transition;
        Object transitionView = this.getViewAdapter().getAdapter(Connector.class);
        if (transitionView instanceof Connector && (transition = ((Connector)transitionView).getElement()) instanceof Transition) {
            IGraphicalEditPart host;
            Vertex vertex = null;
            vertex = isStartEnd ? ((Transition)transition).getSource() : ((Transition)transition).getTarget();
            if (vertex != null && (host = this.getHost()).getModel() instanceof View) {
                View view = (View)this.getHost().getModel();
                Vertex ourVertex = (Vertex)EditPartInheritanceUtils.resolveSemanticElement((EditPart)host, Vertex.class);
                if (vertex == ourVertex || UMLRTExtensionUtil.redefines((Element)ourVertex, (Element)vertex)) {
                    return view;
                }
                view = this.createPseudoStateView(vertex, (Connector)transitionView, view, location);
                return view;
            }
        }
        return null;
    }

    protected View createPseudoStateView(Vertex vertex, Connector transitionView, View view, Point location) {
        SemanticElementAdapter adapter = new SemanticElementAdapter((EObject)vertex);
        PreferencesHint prefs = PreferencesHint.USE_DEFAULTS;
        if (this.getHost().getRoot() instanceof IDiagramPreferenceSupport) {
            prefs = ((IDiagramPreferenceSupport)this.getHost().getRoot()).getPreferencesHint();
        }
        String hint = VisualTypeService.getInstance().getNodeType(view, (EObject)vertex);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)adapter, Node.class, hint, prefs);
        CreateViewRequest request = new CreateViewRequest(descriptor);
        request.setLocation(location);
        Command command = this.getHost().getCommand((Request)request);
        if (command != null && command.canExecute()) {
            command.execute();
        }
        return (Node)descriptor.getAdapter(Node.class);
    }

    protected class ExtremityViewAdaptable
    implements IAdaptable {
        private Point location;
        private boolean isSource;

        public ExtremityViewAdaptable(Point location, boolean isSource) {
            this.location = location;
            this.isSource = isSource;
        }

        public Object getAdapter(Class adapter) {
            if (adapter != null && adapter.isAssignableFrom(ShapeImpl.class)) {
                return RTStateGraphicalNodeEditPolicy.this.getTransitionExtremityView(this.isSource, this.location);
            }
            return null;
        }
    }
}

