/*******************************************************************************
 * Copyright (c) 2016 Zeligsoft (2009) Limited and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Young-Soo Roh - Initial API and implementation
 *******************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.tables.manager.axis;

import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.uml2.uml.Trigger;

/**
 * Axis Manager for the Trigger Table in Papyrus RT
 * 
 * @author Young-Soo Roh
 *
 */
public class TriggerAxisManager extends TransactionalSynchronizedOnFeatureAxisManager {

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager#isAllowedContents(java.lang.Object)
	 */
	@Override
	public boolean isAllowedContents(final Object object) {
		boolean content = false;
		// Check if the object is A trigger for transition
		if (object instanceof Trigger && UMLRTProfileUtils.isUMLRTProfileApplied((Trigger) object)) {
			content = super.isAllowedContents(object);
		}

		return content;
	}
}
