/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CompositeValidator
implements IValidator {
    private final List<IValidator> validators;

    private CompositeValidator(IValidator aValidator, IValidator anotherValidator) {
        if (aValidator instanceof CompositeValidator && anotherValidator instanceof CompositeValidator) {
            CompositeValidator cv1 = (CompositeValidator)aValidator;
            CompositeValidator cv2 = (CompositeValidator)anotherValidator;
            this.validators = new ArrayList<IValidator>(cv1.validators.size() + cv2.validators.size());
            this.validators.addAll(cv1.validators);
            this.validators.addAll(cv2.validators);
        } else if (aValidator instanceof CompositeValidator) {
            CompositeValidator cv1 = (CompositeValidator)aValidator;
            this.validators = new ArrayList<IValidator>(cv1.validators.size() + 1);
            this.validators.addAll(cv1.validators);
            this.validators.add(anotherValidator);
        } else if (anotherValidator instanceof CompositeValidator) {
            CompositeValidator cv2 = (CompositeValidator)anotherValidator;
            this.validators = new ArrayList<IValidator>(1 + cv2.validators.size());
            this.validators.add(aValidator);
            this.validators.addAll(cv2.validators);
        } else {
            this.validators = new ArrayList<IValidator>(2);
            this.validators.add(aValidator);
            this.validators.add(anotherValidator);
        }
    }

    public static IValidator of(IValidator aValidator, IValidator anotherValidator) {
        return aValidator == null ? anotherValidator : (anotherValidator == null ? aValidator : new CompositeValidator(aValidator, anotherValidator));
    }

    public CompositeValidator add(IValidator validator) {
        if (validator instanceof CompositeValidator) {
            this.validators.addAll(((CompositeValidator)validator).validators);
        } else {
            this.validators.add(validator);
        }
        return this;
    }

    public IStatus validate(Object value) {
        return this.validators.stream().map(v -> v.validate(value)).filter(Objects::nonNull).max(this::compareStatus).orElse(Status.OK_STATUS);
    }

    private int compareStatus(IStatus a, IStatus b) {
        return a.getSeverity() - b.getSeverity();
    }
}

