/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.providers.TogglePortState;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Port;

public class TogglePortHandler
extends AbstractHandler {
    protected EObject selectedEObject;
    protected TogglePortState state;

    public void updateSelectedEObject() {
        IStructuredSelection selection = this.getSelection();
        this.selectedEObject = selection != null && selection.size() == 1 ? EMFHelper.getEObject((Object)selection.getFirstElement()) : null;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
    }

    public boolean isEnabled() {
        if (this.state == null) {
            return true;
        }
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Port) {
            return this.getIsEnabled((Port)this.selectedEObject);
        }
        return false;
    }

    public boolean getIsEnabled(Port port) {
        String propertyPath = this.state.getPropertyPath();
        ModelElement modelElement = this.state.getModelElement(port);
        if (modelElement != null) {
            boolean result = modelElement.isEditable(propertyPath);
            modelElement.dispose();
            return result;
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object stateInfo = event.getParameters().get("state");
        if (stateInfo instanceof TogglePortState) {
            this.state = (TogglePortState)((Object)stateInfo);
        } else {
            IObservableValue value;
            ModelElement modelElement = this.state.getModelElement((Port)this.selectedEObject);
            value.setValue((Object)((Boolean)(value = (IObservableValue)modelElement.getObservable(this.state.getPropertyPath())).getValue() == false ? 1 : 0));
            modelElement.dispose();
        }
        return null;
    }
}

