/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.labelprovider;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.CallEventUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.InterfaceRealizationUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UsageUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.labelprovider.LabelUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.labelprovider.UMLRTLabelProvider;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Usage;

public class UMLRTFilteredLabelProvider
extends UMLRTLabelProvider {
    public boolean accept(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (this.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean accept(Object element) {
        if (element instanceof IStructuredSelection) {
            return this.accept((IStructuredSelection)element);
        }
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            return false;
        }
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType)) continue;
            IElementMatcher matcher = ((ISpecializationType)type).getMatcher();
            if (matcher != null) {
                if (!matcher.matches(semanticObject)) continue;
                return true;
            }
            Activator.log.debug("no matcher for this element type: " + type);
        }
        if (semanticObject instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof Interface && MessageSetUtils.isRTMessageSet((Element)((Interface)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof InterfaceRealization && InterfaceRealizationUtils.isInterfaceRealizationFromProtocol((InterfaceRealization)((InterfaceRealization)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof Usage && UsageUtils.isUsageFromProtocol((Usage)((Usage)semanticObject))) {
            return true;
        }
        if (semanticObject instanceof AnyReceiveEvent) {
            return true;
        }
        if (semanticObject instanceof Trigger) {
            Event event = ((Trigger)semanticObject).getEvent();
            return event instanceof AnyReceiveEvent || event instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)event));
        }
        if (semanticObject instanceof Transition) {
            return true;
        }
        if (semanticObject instanceof Constraint) {
            return this.accept(((Constraint)semanticObject).getContext());
        }
        if (semanticObject instanceof OpaqueBehavior) {
            return this.accept(((OpaqueBehavior)semanticObject).getOwner());
        }
        return false;
    }

    @Override
    public Image doGetImage(EObject element) {
        if (!(element instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(element);
        if (matchingTypeMatcher == null) {
            FacadeObject facade;
            if ((element instanceof Constraint || element instanceof OpaqueBehavior) && (facade = UMLRTFactory.create((EObject)element)) != null) {
                return this.baseEMFLabelProvider.getImage((Object)facade);
            }
            if (element instanceof Element) {
                return this.baseEMFLabelProvider.getImage((Object)element);
            }
            return null;
        }
        return super.doGetImage(element);
    }

    @Override
    public String getText(EObject element) {
        ISpecializationType inMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
        if (inMessageType != null && inMessageType.getMatcher() != null && inMessageType.getMatcher().matches(element)) {
            return "in " + super.getText(element);
        }
        ISpecializationType outMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
        if (outMessageType != null && outMessageType.getMatcher() != null && outMessageType.getMatcher().matches(element)) {
            return "out " + super.getText(element);
        }
        ISpecializationType inOutMessageType = (ISpecializationType)UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
        if (inOutMessageType != null && inOutMessageType.getMatcher() != null && inOutMessageType.getMatcher().matches(element)) {
            return "inout " + super.getText(element);
        }
        if (element instanceof CallEvent && CallEventUtils.isProtocolMessageCallEvent((CallEvent)((CallEvent)element))) {
            return LabelUtils.getCallEventForProtocolMessageLabel((CallEvent)element, labelProvider);
        }
        if (element instanceof AnyReceiveEvent) {
            return labelProvider.getText((Object)element);
        }
        if (element instanceof Package && ProtocolContainerUtils.isProtocolContainer((EObject)element)) {
            return LabelUtils.getProtocolContainerLabel((Package)element, labelProvider);
        }
        if (element instanceof Interface && MessageSetUtils.isRTMessageSet((Element)((Interface)element))) {
            return LabelUtils.getMessageSetLabel((Interface)element, labelProvider);
        }
        if (element instanceof InterfaceRealization && InterfaceRealizationUtils.isInterfaceRealizationFromProtocol((InterfaceRealization)((InterfaceRealization)element))) {
            return LabelUtils.getInterfaceRealizationLabel((InterfaceRealization)element, labelProvider);
        }
        if (element instanceof Usage && UsageUtils.isUsageFromProtocol((Usage)((Usage)element))) {
            return LabelUtils.getUsageLabel((Usage)element, labelProvider);
        }
        if (element instanceof Transition) {
            return LabelUtils.getTransitionLabel((Transition)element, labelProvider);
        }
        if (element instanceof Trigger) {
            return LabelUtils.getEventLabel(((Trigger)element).getEvent(), labelProvider);
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element, ETypedElement eTypedElement) {
        if (element instanceof EObject && TransitionUtils.isInternalTransition((EObject)((EObject)element))) {
            return LabelUtils.getInternalTransitionTooltip((Transition)element, labelProvider);
        }
        return super.getToolTipText(element, eTypedElement);
    }
}

