/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.NoDefautLanguage;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class RTPackageObservableValue
extends ReferenceCountedObservable.Value
implements IChangeListener,
CommandBasedObservableValue,
AggregatedObservable,
IObserving {
    private Package rootPackage;
    private TransactionalEditingDomain domain;
    private IDefaultLanguage currentValue;

    public RTPackageObservableValue(Package package_, TransactionalEditingDomain domain) {
        this.rootPackage = package_;
        this.domain = domain;
    }

    public Command getCommand(final Object value) {
        Object command = null;
        if (value != null && !(value instanceof IDefaultLanguage)) {
            command = UnexecutableCommand.INSTANCE;
        } else {
            command = new RecordingCommand(this.domain){

                protected void doExecute() {
                    try {
                        IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)RTPackageObservableValue.this.rootPackage);
                        if (service != null) {
                            service.setActiveDefaultLanguage((Element)RTPackageObservableValue.this.rootPackage, (IDefaultLanguage)value);
                        }
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            };
            this.currentValue = (IDefaultLanguage)value;
        }
        return command;
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        if (command != null && command.canExecute()) {
            this.domain.getCommandStack().execute(command);
        } else {
            Activator.log.error("Impossible to change current default language", null);
        }
    }

    public Object getValueType() {
        return IDefaultLanguage.class;
    }

    public Object getObserved() {
        return this.rootPackage;
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue((EditingDomain)this.domain, new IObservable[]{this, observable});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }

    public void handleChange(ChangeEvent event) {
        this.fireValueChange(Diffs.createValueDiff((Object)this.currentValue, (Object)this.doGetValue()));
    }

    protected IDefaultLanguage doGetValue() {
        if (this.rootPackage instanceof Package) {
            try {
                IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)this.rootPackage);
                if (service != null) {
                    return service.getActiveDefaultLanguage((Element)this.rootPackage);
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return NoDefautLanguage.INSTANCE;
    }
}

