/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Trigger;

public class ProtocolMsgContentProvider
implements IStaticContentProvider,
ITreeContentProvider {
    Trigger trigger;
    EList<UMLRTProtocol> protocols;
    boolean errorShown;

    public ProtocolMsgContentProvider(Trigger trigger) {
        this.trigger = trigger;
        this.errorShown = false;
        this.updateProtocols();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.updateProtocols();
        if (viewer instanceof TreeViewer) {
            final TreeViewer treeViewer = (TreeViewer)viewer;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    treeViewer.expandAll();
                }
            });
        }
    }

    protected void updateProtocols() {
        this.protocols = new UniqueEList();
        if (this.trigger != null) {
            for (Port port : this.trigger.getPorts()) {
                UMLRTProtocol protocol;
                UMLRTPort facade = UMLRTPort.getInstance((Port)port);
                if (facade == null || (protocol = facade.getType()) == null) continue;
                this.protocols.add((Object)protocol);
            }
        }
    }

    public Object[] getElements() {
        ArrayList<AnyReceiveEvent> events = new ArrayList<AnyReceiveEvent>();
        if (this.protocols.size() > 0) {
            events.add(((UMLRTProtocol)this.protocols.get(0)).getAnyReceiveEvent());
        }
        return events.toArray();
    }

    public Object[] getChildren(Object parent) {
        ArrayList<UMLRTProtocolMessage> protocolMsgs = new ArrayList<UMLRTProtocolMessage>();
        UniqueEList allProtocols = new UniqueEList();
        for (UMLRTProtocol protocol : this.protocols) {
            allProtocols.addAll((Collection)ProtocolUtils.getAllProtocols((UMLRTProtocol)protocol));
        }
        for (UMLRTProtocol protocol : allProtocols) {
            if (!ProtocolUtils.isCommonProtocol(this.protocols, (UMLRTProtocol)protocol)) continue;
            this.addProtocolMsgs(protocolMsgs, protocol);
        }
        return protocolMsgs.stream().sorted(UMLRTInheritanceKind.facadeComparator()).map(UMLRTProtocolMessage::toReceiveEvent).toArray();
    }

    public Object getParent(Object parent) {
        return null;
    }

    public boolean hasChildren(Object event) {
        return event instanceof AnyReceiveEvent;
    }

    protected void addProtocolMsgs(ArrayList<UMLRTProtocolMessage> events, UMLRTProtocol protocol) {
        for (UMLRTProtocolMessage message : protocol.getMessages()) {
            RTMessageKind kind = message.getKind();
            if (kind != RTMessageKind.IN_OUT && kind != RTMessageKind.IN || message.toReceiveEvent() == null) continue;
            events.add(message);
        }
    }
}

