/*******************************************************************************
 * Copyright (c) 2017 Zeligsoft (2009) Limited and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Young-Soo Roh - Initial API and implementation
 *******************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList.Expression;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;

/**
 * Code snippet tab for operation.
 * 
 * @author ysroh
 *
 */
public class OperationTab extends AbstractCodeSnippetTab {

	/**
	 * 
	 * Constructor.
	 *
	 */
	public OperationTab() {
	}

	@Override
	public String getTitle() {
		return "Operation";
	}

	@Override
	public Image getImage() {
		if (shouldShowThisTab(input)) {
			Operation op = (Operation) input;
			if (!op.getMethods().isEmpty()) {
				return labelProvider.getImage(op.getMethods().get(0));
			}
		}
		return null;
	}

	@Override
	public boolean shouldShowThisTab(EObject context) {
		if (context instanceof Operation && context.eContainer() instanceof org.eclipse.uml2.uml.Class) {
			return UMLRTProfileUtils.isUMLRTProfileApplied((Operation) context);
		}
		return false;
	}

	@Override
	protected IObservable getFeatureObservable() {
		UMLModelElement modelElement = new UMLModelElement(input);
		return modelElement.doGetObservable("method");
	}

	@Override
	protected ExpressionList getExpressionObservableList() {
		Operation op = (Operation) input;
		if (!op.getMethods().isEmpty()) {
			return getExpressionList(op.getMethods().get(0));
		}
		return null;
	}

	@Override
	protected void saveInitialExpression(Expression ex) {
		Operation op = (Operation) input;
		Class container = (Class) input.eContainer();
		OpaqueBehavior ob = CodeSnippetUtils.createOpaqueBehaviorWithDefaultLanguage(container);
		if (ex.getLanguage().equals(ob.getLanguages().get(0))) {
			ob.getBodies().set(0, ex.getBody());
		} else {
			ob.getLanguages().add(ex.getLanguage());
			ob.getBodies().add(ex.getBody());
		}
		container.getOwnedBehaviors().add(ob);
		op.getMethods().add(ob);
	}

}
