/*******************************************************************************
 * Copyright (c) 2017 Zeligsoft (2009) Limited and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Young-Soo Roh - Initial API and implementation
 *******************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList.Expression;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

/**
 * Code snippet tab for trigger guard.
 * 
 * @author ysroh
 *
 */
public class TriggerGuardTab extends AbstractCodeSnippetTab {

	/**
	 * 
	 * Constructor.
	 *
	 */
	public TriggerGuardTab() {
	}

	@Override
	public String getTitle() {
		return "Trigger Guard";
	}

	@Override
	public Image getImage() {
		if (shouldShowThisTab(input)) {
			Trigger trigger = (Trigger) input;
			Constraint guard = CodeSnippetUtils.getTriggerGuard(trigger);
			if (guard != null) {
				return labelProvider.getImage(guard);
			}
		}

		return org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator
				.getImage(org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator.IMG_OBJ16_GUARD);
	}

	@Override
	public boolean shouldShowThisTab(EObject context) {
		if (context instanceof Trigger) {
			Transition transition = (Transition) context.eContainer();
			StateMachine sm = transition.containingStateMachine();
			return StateMachineUtils.isRTStateMachine(sm);
		}
		return false;
	}

	@Override
	protected IObservable getFeatureObservable() {
		Transition transition = (Transition) input.eContainer();
		UMLModelElement modelElement = new UMLModelElement(transition);
		return modelElement.doGetObservable("ownedRule");
	}

	@Override
	protected ExpressionList getExpressionObservableList() {
		Trigger trigger = (Trigger) input;
		Constraint guard = CodeSnippetUtils.getTriggerGuard(trigger);
		if (guard != null) {
			return getExpressionList(guard.getSpecification());
		}
		return null;
	}

	@Override
	protected void saveInitialExpression(Expression ex) {
		UMLRTTrigger trigger = UMLRTFactory.createTrigger((Trigger) input);
		trigger.createGuard(ex.getLanguage(), ex.getBody());
	}
}
