/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.widgets.databinding.TextObservableValue;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors.AbstractLanguageEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TextLanguageEditor
extends AbstractLanguageEditor {
    protected Text text;
    protected IObservable textObservable;

    @Override
    public void dispose() {
        this.textObservable.dispose();
        super.dispose();
    }

    @Override
    protected void createContents(Composite parent) {
        this.text = new Text(parent, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textObservable = new TextObservableValue(this.text, null, 16);
        this.textObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (TextLanguageEditor.this.text.getText().equals(TextLanguageEditor.this.expression.getBody())) {
                    return;
                }
                ExpressionList.Expression oldEx = new ExpressionList.Expression();
                oldEx.setLanguage(TextLanguageEditor.this.expression.getLanguage());
                oldEx.setBody(TextLanguageEditor.this.expression.getBody());
                TextLanguageEditor.this.expression.setBody(TextLanguageEditor.this.text.getText());
                ValueDiff diff = Diffs.createValueDiff((Object)oldEx, (Object)TextLanguageEditor.this.expression);
                TextLanguageEditor.this.fireValueChange(diff);
            }
        });
    }

    @Override
    protected void refresh() {
        if (!this.text.isDisposed()) {
            this.text.setText(this.expression.getBody() == null ? "" : this.expression.getBody());
        }
    }
}

