/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal.ICodeSnippetPage;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ICodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.OperationTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.StateEntryTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.StateExitTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionEffectTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionGuardTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TriggerGuardTab;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public class CodeSnippetPage
extends Page
implements ICodeSnippetPage {
    private Composite pageControl;
    private EObject currentSelectedEObject;
    private CTabFolder tabFolder;
    private CTabItem defaultTabItem;
    private List<ICodeSnippetTab> tabs = new ArrayList<ICodeSnippetTab>();
    private Map<ICodeSnippetTab, CTabItem> tabItems = new HashMap<ICodeSnippetTab, CTabItem>();
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            if (selection.isEmpty()) {
                this.currentSelectedEObject = null;
            } else {
                EObject eo = EMFHelper.getEObject((Object)((IStructuredSelection)selection).getFirstElement());
                if (eo != null && !eo.equals(this.currentSelectedEObject)) {
                    this.currentSelectedEObject = eo;
                }
            }
            for (ICodeSnippetTab tab : this.tabs) {
                if (tab.shouldShowThisTab(this.currentSelectedEObject)) {
                    CTabItem tabItem = this.tabItems.get(tab);
                    if (tabItem == null) {
                        tabItem = tab.createControl(this.tabFolder);
                        this.tabItems.put(tab, tabItem);
                        if (this.tabFolder.getSelection() == null) {
                            this.tabFolder.setSelection(0);
                        }
                    }
                    tab.setInput(this.currentSelectedEObject);
                    continue;
                }
                this.tabItems.remove(tab);
                tab.dispose();
            }
            if (this.tabItems.isEmpty()) {
                this.createDefaultTabItem();
                this.tabFolder.setSelection(0);
            } else if (this.defaultTabItem != null) {
                this.defaultTabItem.dispose();
                this.defaultTabItem = null;
            }
            this.fireSelectionChangedEvent();
        }
    }

    private void fireSelectionChangedEvent() {
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void createControl(Composite parent) {
        this.tabs.add(new TransitionEffectTab());
        this.tabs.add(new TransitionGuardTab());
        this.tabs.add(new StateEntryTab());
        this.tabs.add(new StateExitTab());
        this.tabs.add(new TriggerGuardTab());
        this.tabs.add(new OperationTab());
        this.pageControl = new Composite(parent, 0);
        this.pageControl.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(this.pageControl, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    private void createDefaultTabItem() {
        if (this.defaultTabItem == null) {
            this.defaultTabItem = new CTabItem(this.tabFolder, 0);
            final Composite tabComposite = new Composite((Composite)this.tabFolder, 0);
            tabComposite.setLayoutData((Object)new GridData());
            tabComposite.setLayout((Layout)new GridLayout());
            CLabel label = new CLabel(tabComposite, 0);
            label.setLayoutData((Object)new GridData(16384, 128, false, false));
            label.setText("Code snippet view is not available for the current selection.");
            this.defaultTabItem.setControl((Control)tabComposite);
            this.defaultTabItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (tabComposite != null) {
                        tabComposite.dispose();
                    }
                }
            });
        }
    }

    public Control getControl() {
        return this.pageControl;
    }

    public void setFocus() {
        this.pageControl.setFocus();
    }

    public void dispose() {
        this.getSite().setSelectionProvider(null);
        if (this.pageControl != null) {
            this.pageControl.dispose();
        }
        super.dispose();
    }

    public ISelection getSelection() {
        StructuredSelection selection = new StructuredSelection();
        if (this.currentSelectedEObject != null) {
            boolean isTrigger = this.tabItems.keySet().stream().anyMatch(t -> t instanceof TriggerGuardTab);
            selection = isTrigger ? new StructuredSelection((Object)this.currentSelectedEObject.eContainer()) : new StructuredSelection((Object)this.currentSelectedEObject);
        }
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }
}

