/*****************************************************************************
 * Copyright (c) 2017 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.uml.internal.impl;

import java.util.stream.Stream;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * Internal protocol for transitions.
 */
public interface InternalUMLRTTransition extends InternalUMLRTRedefinitionContext<InternalUMLRTTransition>, Transition {

	@Override
	default Stream<? extends InternalUMLRTTransition> rtDescendants() {
		return CacheAdapter.getInstance().getNonNavigableInverseReferences(this).stream()
				.filter(setting -> setting.getEStructuralFeature() == UMLPackage.Literals.TRANSITION__REDEFINED_TRANSITION)
				.map(EStructuralFeature.Setting::getEObject)
				.filter(InternalUMLRTTransition.class::isInstance)
				.filter(g -> g.eClass() == eClass())
				.map(InternalUMLRTTransition.class::cast);
	}

	/**
	 * Obtains the effect, with or without proxy resolution, according to UML semantics.
	 * 
	 * @param resolve
	 *            whether to resolve proxies
	 * 
	 * @return the UML-ish effect (not inherited)
	 */
	Behavior umlGetEffect(boolean resolve);

	/**
	 * Basic-sets the effect, according to UML semantics.
	 * 
	 * @param newEffect
	 *            the new effect
	 * @param msgs
	 *            an incoming notification chain to append, or {@code null} if none, yet
	 * 
	 * @return the outgoing notifications
	 */
	NotificationChain umlBasicSetEffect(Behavior newEffect, NotificationChain msgs);

	/**
	 * Protocol for basic access to the guard as generated by EMF.
	 * 
	 * @return the basic guard reference
	 */
	Constraint basicGetGuard();
}
