/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.uml;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Scope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Thunk;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.Name;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.QualifiedName;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.NoResourceFound;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.UMLThunk;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class UMLScope
implements Scope {
    private NamedElement context;
    private final HashMap<ArrayList<?>, Name> _createCache_canonicalName = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public UMLScope(NamedElement element) {
        this.context = element;
    }

    public Thunk get(Name name) {
        UMLThunk _xifexpression = null;
        _xifexpression = name instanceof QualifiedName ? this.resolveQualifiedName((QualifiedName)name, this.context) : this.resolveUnqualifiedName(name, this.context);
        return _xifexpression;
    }

    private UMLThunk _resolveUnqualifiedName(Name nameToLookFor, NamedElement context) {
        return null;
    }

    private UMLThunk _resolveUnqualifiedName(final Name nameToLookFor, Classifier context) {
        UMLThunk _xblockexpression = null;
        EList _attributes = context.getAttributes();
        Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property it) {
                String _name = it.getName();
                String _text = nameToLookFor.getText();
                return Objects.equal((Object)_name, (Object)_text);
            }
        };
        Property attr = (Property)IterableExtensions.findFirst((Iterable)_attributes, (Functions.Function1)_function);
        UMLThunk _xifexpression = null;
        if (attr != null) {
            _xifexpression = this.thunkForAttribute(attr);
        } else {
            UMLThunk _xblockexpression_1 = null;
            EObject container = context.eContainer();
            UMLThunk _xifexpression_1 = null;
            if (container instanceof NamedElement) {
                _xifexpression_1 = this.resolveUnqualifiedName(nameToLookFor, (NamedElement)container);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private UMLThunk resolveQualifiedName(QualifiedName name, NamedElement context) {
        UMLThunk _xblockexpression = null;
        String[] _segments = null;
        if (name != null) {
            _segments = name.getSegments();
        }
        String _get = null;
        if (_segments != null) {
            _get = _segments[0];
        }
        String targetModelName = _get;
        Model _model = null;
        if (context != null) {
            _model = context.getModel();
        }
        String _name = null;
        if (_model != null) {
            _name = _model.getName();
        }
        String contextModelName = _name;
        UMLThunk _xifexpression = null;
        if (targetModelName != null && contextModelName != null) {
            Model _findModel;
            Model _model_1;
            UMLThunk _xblockexpression_1 = null;
            Model targetModel = null;
            boolean _equals = Objects.equal((Object)targetModelName, (Object)contextModelName);
            targetModel = _equals ? (_model_1 = context.getModel()) : (_findModel = this.findModel(targetModelName, (Element)context));
            _xifexpression = _xblockexpression_1 = this.resolveInModel(name, targetModel);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Model findModel(String name, Element context) {
        Model _xblockexpression = null;
        String resourceName = String.valueOf(name) + "/" + name + ".uml";
        URI uri = URI.createPlatformResourceURI((String)resourceName, (boolean)true);
        ResourceSet resourceSet = this.getResourceSet(context);
        Model model = this.findModelInResourceSet(name, resourceSet);
        if (model == null) {
            Model _head;
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null) {
                String _string = uri.toString();
                throw new NoResourceFound(_string);
            }
            EList _contents = resource.getContents();
            Iterable _filter = Iterables.filter((Iterable)_contents, Model.class);
            model = _head = (Model)IterableExtensions.head((Iterable)_filter);
        }
        _xblockexpression = model;
        return _xblockexpression;
    }

    private ResourceSet getResourceSet(Element element) {
        ResourceSet resourceSet;
        ResourceSet _xblockexpression = null;
        Resource _eResource = null;
        if (element != null) {
            _eResource = element.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        if ((resourceSet = _resourceSet) == null && element instanceof UMLRTNamedElement) {
            Model _model = element.getModel();
            Resource _eResource_1 = null;
            if (_model != null) {
                _eResource_1 = _model.eResource();
            }
            ResourceSet _resourceSet_1 = null;
            if (_eResource_1 != null) {
                _resourceSet_1 = _eResource_1.getResourceSet();
            }
            if ((resourceSet = _resourceSet_1) == null) {
                String _elvis = null;
                Model _model_1 = element.getModel();
                String _name = null;
                if (_model_1 != null) {
                    _name = _model_1.getName();
                }
                _elvis = _name != null ? _name : "<unnamed-model>";
                String model_name = _elvis;
                throw new NoResourceFound(model_name);
            }
        }
        _xblockexpression = resourceSet;
        return _xblockexpression;
    }

    private Model findModelInResourceSet(String name, ResourceSet set) {
        EList _resources = set.getResources();
        for (Resource resource : _resources) {
            EList _contents = resource.getContents();
            for (EObject eobj : _contents) {
                if (!(eobj instanceof Model) || !Objects.equal((Object)((Model)eobj).getName(), (Object)name)) continue;
                return (Model)eobj;
            }
        }
        return null;
    }

    private UMLThunk resolveInModel(QualifiedName name, Model container) {
        UMLThunk _xblockexpression = null;
        NamedElement element = this.findElement(name, container);
        UMLThunk _xifexpression = null;
        if (element instanceof Property) {
            _xifexpression = this.thunkForAttribute((Property)element);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private NamedElement findElement(QualifiedName name, Model container) {
        if (container != null) {
            String[] segments;
            String[] _segments = null;
            if (name != null) {
                _segments = name.getSegments();
            }
            if ((segments = _segments) != null && !((List)Conversions.doWrapArray((Object)segments)).isEmpty()) {
                Model element = container;
                String segment = segments[0];
                int i = 1;
                while (i < segments.length && element != null && Objects.equal((Object)segment, (Object)element.getName())) {
                    String _get;
                    segment = _get = segments[i];
                    NamedElement _visibleNestedMember = this.getVisibleNestedMember((Element)element, segment);
                    element = _visibleNestedMember;
                    ++i;
                }
                return element;
            }
        }
        return null;
    }

    private NamedElement _getVisibleNestedMember(Class namespace, String elementName) {
        NamedElement _xblockexpression = null;
        Classifier element = namespace.getNestedClassifier(elementName);
        Object _xifexpression = null;
        _xifexpression = element != null && Objects.equal((Object)element.getVisibility(), (Object)VisibilityKind.PUBLIC_LITERAL) ? element : this.getVisibleAttribute((Classifier)namespace, elementName);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private NamedElement _getVisibleNestedMember(Package namespace, String elementName) {
        PackageableElement _xblockexpression = null;
        PackageableElement element = namespace.getPackagedElement(elementName);
        PackageableElement _xifexpression = null;
        if (element != null && namespace.makesVisible((NamedElement)element)) {
            _xifexpression = element;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private NamedElement _getVisibleNestedMember(Classifier namespace, String elementName) {
        return this.getVisibleAttribute(namespace, elementName);
    }

    private NamedElement _getVisibleNestedMember(Element namespace, String elementName) {
        return null;
    }

    private NamedElement getVisibleAttribute(Classifier classifier, String attributeName) {
        Property _xblockexpression = null;
        Property element = classifier.getAttribute(attributeName, null);
        Property _xifexpression = null;
        if (element != null && Objects.equal((Object)element.getVisibility(), (Object)VisibilityKind.PUBLIC_LITERAL)) {
            _xifexpression = element;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private UMLThunk thunkForAttribute(Property attr) {
        UMLThunk _xblockexpression = null;
        Element _owner = null;
        if (attr != null) {
            _owner = attr.getOwner();
        }
        Classifier context = (Classifier)_owner;
        ValueSpecification _defaultValue = null;
        if (attr != null) {
            _defaultValue = attr.getDefaultValue();
        }
        ValueSpecification attrDefault = _defaultValue;
        UMLScope _uMLScope = new UMLScope((NamedElement)context);
        _xblockexpression = new UMLThunk(attrDefault, _uMLScope);
        return _xblockexpression;
    }

    public Object context() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name canonicalName(Name name) {
        QualifiedName _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Name[]{name});
        HashMap<ArrayList<?>, Name> hashMap = this._createCache_canonicalName;
        synchronized (hashMap) {
            if (this._createCache_canonicalName.containsKey(_cacheKey)) {
                return this._createCache_canonicalName.get(_cacheKey);
            }
            QualifiedName _xifexpression = null;
            if (name instanceof QualifiedName) {
                _xifexpression = (QualifiedName)name;
            } else {
                QualifiedName _xblockexpression = null;
                List<Element> _containerList = UMLScope.getContainerList((Element)this.context);
                Functions.Function1<Element, String> _function = new Functions.Function1<Element, String>(){

                    public String apply(Element it) {
                        return UMLScope.this.nameOf(it);
                    }
                };
                List _map = ListExtensions.map(_containerList, (Functions.Function1)_function);
                List segments = IterableExtensions.toList((Iterable)_map);
                String _text = name.getText();
                String _text_1 = name.getText();
                Iterable _plus = Iterables.concat((Iterable)segments, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_text_1})));
                _xifexpression = _xblockexpression = new QualifiedName(_text, (String[])Conversions.unwrapArray((Object)_plus, String.class));
            }
            _result = _xifexpression;
            this._createCache_canonicalName.put(_cacheKey, (Name)_result);
        }
        this._init_canonicalName(_result, name);
        return _result;
    }

    private void _init_canonicalName(QualifiedName it, Name name) {
    }

    private String nameOf(Element element) {
        String _xblockexpression = null;
        String name = "";
        if (element != null) {
            boolean _isEmpty;
            if (element instanceof NamedElement) {
                String _elvis = null;
                String _name = ((NamedElement)element).getName();
                _elvis = _name != null ? _name : "";
                name = _elvis;
            }
            if (_isEmpty = name.isEmpty()) {
                boolean _equals;
                EStructuralFeature feature = element.eContainingFeature();
                int _upperBound = feature.getUpperBound();
                boolean bl = _equals = _upperBound == 1;
                if (_equals) {
                    String _name_1;
                    name = _name_1 = feature.getName();
                } else {
                    EObject container = element.eContainer();
                    Object featureValue = container.eGet(feature);
                    if (featureValue instanceof List) {
                        String _plus;
                        String _name_2 = feature.getName();
                        int _indexOf = ((List)featureValue).indexOf(element);
                        name = _plus = String.valueOf(_name_2) + Integer.valueOf(_indexOf);
                    } else {
                        String _plus_1;
                        String _name_3 = feature.getName();
                        name = _plus_1 = String.valueOf(_name_3) + "_value";
                    }
                }
            }
        }
        _xblockexpression = name;
        return _xblockexpression;
    }

    public Name contextName() {
        QualifiedName _xblockexpression = null;
        List<Element> _containerList = UMLScope.getContainerList((Element)this.context);
        Functions.Function1<Element, String> _function = new Functions.Function1<Element, String>(){

            public String apply(Element it) {
                return UMLScope.this.nameOf(it);
            }
        };
        List _map = ListExtensions.map(_containerList, (Functions.Function1)_function);
        List segments = IterableExtensions.toList((Iterable)_map);
        String _name = this.context.getName();
        _xblockexpression = new QualifiedName(_name, (String[])Conversions.unwrapArray((Object)segments, String.class));
        return _xblockexpression;
    }

    private static List<Element> getContainerList(Element element) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Element[0]);
        Element elem = element;
        while (elem != null) {
            Element _owner;
            result.add(0, elem);
            elem = _owner = elem.getOwner();
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private UMLThunk resolveUnqualifiedName(Name nameToLookFor, NamedElement context) {
        if (context instanceof Classifier) {
            return this._resolveUnqualifiedName(nameToLookFor, (Classifier)context);
        }
        if (context != null) {
            return this._resolveUnqualifiedName(nameToLookFor, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameToLookFor, context).toString());
    }

    private NamedElement getVisibleNestedMember(Element namespace, String elementName) {
        if (namespace instanceof Class) {
            return this._getVisibleNestedMember((Class)namespace, elementName);
        }
        if (namespace instanceof Classifier) {
            return this._getVisibleNestedMember((Classifier)namespace, elementName);
        }
        if (namespace instanceof Package) {
            return this._getVisibleNestedMember((Package)namespace, elementName);
        }
        if (namespace != null) {
            return this._getVisibleNestedMember(namespace, elementName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(namespace, elementName).toString());
    }
}

