/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.eval;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.AExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.BinExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Num;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Op;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.UnaryExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Var;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.CycleDetectedException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.InvalidVariableValueException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.UnrecognizedOperatorException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.UnresolvedVariableException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Scope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.SimpleScope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Thunk;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.Name;
import org.eclipse.papyrusrt.xtumlrt.aexpr.parser.AExprParser;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class AExprEvaluator {
    protected final AExprParser parser = new AExprParser();

    public int eval(String expr) {
        int _xblockexpression = 0;
        AExpr parsed = this.parser.parse(expr);
        SimpleScope _simpleScope = new SimpleScope((Map)((Object)Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Object[0]))));
        Stack<Name> _stack = new Stack<Name>();
        _xblockexpression = this.eval(parsed, _simpleScope, _stack);
        return _xblockexpression;
    }

    public int eval(String expr, Scope scope) {
        int _xblockexpression = 0;
        AExpr parsed = this.parser.parse(expr);
        Stack<Name> _stack = new Stack<Name>();
        _xblockexpression = this.eval(parsed, scope, _stack);
        return _xblockexpression;
    }

    protected int _eval(Num expr, Scope scope, Stack<Name> seen) {
        return expr.getValue();
    }

    protected int _eval(Var expr, Scope scope, Stack<Name> seen) {
        Thunk thunk;
        int _xblockexpression = 0;
        Name _name = expr.getName();
        Name canonicalName = scope.canonicalName(_name);
        boolean _contains = seen.contains(canonicalName);
        if (_contains) {
            throw new CycleDetectedException(expr, scope);
        }
        Thunk _get = null;
        if (scope != null) {
            Name _name_1 = expr.getName();
            _get = scope.get(_name_1);
        }
        if ((thunk = _get) == null) {
            throw new UnresolvedVariableException(expr, scope);
        }
        _xblockexpression = this.evalThunk(thunk, canonicalName, expr, scope, seen);
        return _xblockexpression;
    }

    protected int _eval(UnaryExpr expr, Scope scope, Stack<Name> seen) {
        int _switchResult;
        block5: {
            block4: {
                _switchResult = 0;
                Op _op = expr.getOp();
                if (_op == null) break block4;
                switch (_op) {
                    case PLUS: {
                        AExpr _operand = expr.getOperand();
                        _switchResult = this.eval(_operand, scope, seen);
                        break block5;
                    }
                    case MINUS: {
                        AExpr _operand_1 = expr.getOperand();
                        int _eval = this.eval(_operand_1, scope, seen);
                        _switchResult = -_eval;
                        break block5;
                    }
                    default: {
                        throw new UnrecognizedOperatorException(expr, scope);
                    }
                }
            }
            throw new UnrecognizedOperatorException(expr, scope);
        }
        return _switchResult;
    }

    protected int _eval(BinExpr expr, Scope scope, Stack<Name> seen) {
        int _switchResult;
        block8: {
            block7: {
                _switchResult = 0;
                Op _op = expr.getOp();
                if (_op == null) break block7;
                switch (_op) {
                    case PLUS: {
                        AExpr _left = expr.getLeft();
                        int _eval = this.eval(_left, scope, seen);
                        AExpr _right = expr.getRight();
                        int _eval_1 = this.eval(_right, scope, seen);
                        _switchResult = _eval + _eval_1;
                        break block8;
                    }
                    case MINUS: {
                        AExpr _left_1 = expr.getLeft();
                        int _eval_2 = this.eval(_left_1, scope, seen);
                        AExpr _right_1 = expr.getRight();
                        int _eval_3 = this.eval(_right_1, scope, seen);
                        _switchResult = _eval_2 - _eval_3;
                        break block8;
                    }
                    case TIMES: {
                        AExpr _left_2 = expr.getLeft();
                        int _eval_4 = this.eval(_left_2, scope, seen);
                        AExpr _right_2 = expr.getRight();
                        int _eval_5 = this.eval(_right_2, scope, seen);
                        _switchResult = _eval_4 * _eval_5;
                        break block8;
                    }
                    case DIV: {
                        AExpr _left_3 = expr.getLeft();
                        int _eval_6 = this.eval(_left_3, scope, seen);
                        AExpr _right_3 = expr.getRight();
                        int _eval_7 = this.eval(_right_3, scope, seen);
                        _switchResult = _eval_6 / _eval_7;
                        break block8;
                    }
                    case MOD: {
                        AExpr _left_4 = expr.getLeft();
                        int _eval_8 = this.eval(_left_4, scope, seen);
                        AExpr _right_4 = expr.getRight();
                        int _eval_9 = this.eval(_right_4, scope, seen);
                        _switchResult = _eval_8 % _eval_9;
                        break block8;
                    }
                    default: {
                        throw new UnrecognizedOperatorException(expr, scope);
                    }
                }
            }
            throw new UnrecognizedOperatorException(expr, scope);
        }
        return _switchResult;
    }

    protected int evalThunk(Thunk thunk, Name canonicalName, Var expr, Scope scope, Stack<Name> seen) {
        int _xblockexpression = 0;
        Object object = thunk.getValue();
        int _xifexpression = 0;
        if (!(object instanceof Integer)) {
            if (object instanceof String) {
                AExpr parsedExpr = this.parser.parse((String)object);
                seen.push(canonicalName);
                Scope _scope = thunk.getScope();
                int result = this.eval(parsedExpr, _scope, seen);
                seen.pop();
                return result;
            }
            if (object instanceof AExpr) {
                seen.push(canonicalName);
                Scope _scope_1 = thunk.getScope();
                int result_1 = this.eval((AExpr)object, _scope_1, seen);
                seen.pop();
                return result_1;
            }
            throw new InvalidVariableValueException(expr, scope);
        }
        _xifexpression = (Integer)object;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public int eval(AExpr expr, Scope scope, Stack<Name> seen) {
        if (expr instanceof BinExpr) {
            return this._eval((BinExpr)expr, scope, seen);
        }
        if (expr instanceof Num) {
            return this._eval((Num)expr, scope, seen);
        }
        if (expr instanceof UnaryExpr) {
            return this._eval((UnaryExpr)expr, scope, seen);
        }
        if (expr instanceof Var) {
            return this._eval((Var)expr, scope, seen);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr, scope, seen).toString());
    }
}

