/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.to.uml.ui.handlers;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrusrt.xtumlrt.trans.to.uml.TextToModelGeneration;
import org.eclipse.papyrusrt.xtumlrt.trans.to.uml.ui.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;

public class TransformActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection.isEmpty()) {
            return null;
        }
        Object selected = selection.getFirstElement();
        if (selected instanceof IAdaptable) {
            IStatus status = Status.CANCEL_STATUS;
            IFile file = (IFile)((IAdaptable)selected).getAdapter(IFile.class);
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            AbstractModule injectorModule = Activator.getDefault().getInjectorModule(file.getFileExtension());
            if (injectorModule != null) {
                Injector injector = Guice.createInjector((Module[])new Module[]{injectorModule});
                TextToModelGeneration generator = (TextToModelGeneration)injector.getInstance(TextToModelGeneration.class);
                status = generator.generate(uri);
            }
            MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 34);
            dialog.setText("Information");
            if (status.getSeverity() == 4) {
                dialog.setMessage("Operation failed: " + status.getException().getMessage());
            } else if (status.getSeverity() == 8) {
                dialog.setMessage("Operation cancelled.");
            } else {
                dialog.setMessage("Operation completed.");
            }
            dialog.open();
        }
        return null;
    }
}

