/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.cpp.validation.StatusFactory;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.statemach.CompositeState;
import org.eclipse.papyrusrt.xtumlrt.statemach.EntryPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.ExitPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.State;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition;
import org.eclipse.papyrusrt.xtumlrt.statemach.Vertex;
import org.eclipse.papyrusrt.xtumlrt.trans.TransformValidator;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtTranslator;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTExtensions;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PostUML2xtumlrtValidator
implements TransformValidator<EObject> {
    private UML2xtumlrtTranslator translator;

    public PostUML2xtumlrtValidator(UML2xtumlrtTranslator translator) {
        this.translator = translator;
    }

    public MultiStatus validate(EObject element) {
        MultiStatus _xblockexpression = null;
        final MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
        TreeIterator _eAllContents = element.eAllContents();
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                PostUML2xtumlrtValidator.this.validateGeneratedElement(it, status);
            }
        };
        IteratorExtensions.forEach((Iterator)_eAllContents, (Procedures.Procedure1)_function);
        _xblockexpression = status;
        return _xblockexpression;
    }

    protected void validateGeneratedElement(EObject o, MultiStatus result) {
        if (o instanceof CommonElement) {
            Element source = this.translator.getSource((CommonElement)o);
            this.validateElement(o, (EObject)source, result);
        }
    }

    protected void _validateElement(EObject o, EObject source, MultiStatus result) {
    }

    protected void _validateElement(Transition t, EObject source, MultiStatus result) {
        Vertex targetNode;
        if (source == null) {
            return;
        }
        EObject transitionOwner = t.eContainer();
        Vertex sourceNode = t.getSourceVertex();
        if (sourceNode instanceof EntryPoint || sourceNode instanceof ExitPoint) {
            EObject _eContainer = sourceNode.eContainer();
            sourceNode = _eContainer;
        }
        if ((targetNode = t.getTargetVertex()) instanceof EntryPoint || targetNode instanceof ExitPoint) {
            EObject _eContainer_1 = sourceNode.eContainer();
            targetNode = _eContainer_1;
        }
        if (sourceNode instanceof CompositeState && sourceNode == targetNode) {
            if (t.getSourceVertex() instanceof EntryPoint || t.getTargetVertex() instanceof ExitPoint) {
                if (targetNode != transitionOwner) {
                    StatusFactory.addErrorStatus(source, "The transition's owner is not the composite state that owns its source and target.", "A \"through\" transition must be owned by its source and target state (which are the same).", result);
                }
            } else if (targetNode != transitionOwner && targetNode.eContainer() != transitionOwner) {
                StatusFactory.addErrorStatus(source, "The transition does not belong to the correct state.", "The transition's owner must be either its target state or it's target's state owner.", result);
            }
        } else if (t.getSourceVertex() instanceof EntryPoint || sourceNode == targetNode.eContainer()) {
            if (sourceNode != transitionOwner) {
                StatusFactory.addErrorStatus(source, "The transition is not owned by it's source state.", "An \"entering\" transition must be owned by its source state, which itself must own the transition's target.", result);
            }
        } else if (t.getTargetVertex() instanceof ExitPoint || targetNode == sourceNode.eContainer()) {
            if (targetNode != transitionOwner) {
                StatusFactory.addErrorStatus(source, "The transition is not owned by it's target state.", "An \"exiting\" transition must be owned by its target state, which itself must own the transition's source.", result);
            }
        } else {
            EObject _eContainer_3;
            boolean _tripleEquals;
            EObject _eContainer_2 = sourceNode.eContainer();
            boolean bl = _tripleEquals = _eContainer_2 == (_eContainer_3 = targetNode.eContainer());
            if (_tripleEquals) {
                boolean _tripleNotEquals;
                EObject _eContainer_4 = targetNode.eContainer();
                boolean bl2 = _tripleNotEquals = _eContainer_4 != transitionOwner;
                if (_tripleNotEquals) {
                    StatusFactory.addErrorStatus(source, "The transition's owner is not the composite state that owns its source and target.", "A \"sibling\" transition must be owned by the same composite state that owns its source and target states.", result);
                }
            }
        }
    }

    protected void _validateElement(final Port port, EObject source, MultiStatus result) {
        Functions.Function1<Port, Boolean> _function;
        Iterable allParentPorts;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)port);
        Capsule capsule = (Capsule)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Capsule && (_exists = IterableExtensions.exists((Iterable)(allParentPorts = XTUMLRTExtensions.getAllRTPorts((Capsule)((Capsule)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it.getName(), (Object)port.getName()) && port.getRedefines() != it;
            }
        })))) {
            StatusFactory.addErrorStatus(source, "Port has the same name as a port in the parent capsule but it does not redefine it.", "A named element that redefines another named element must have the same name.", result);
        }
    }

    protected void _validateElement(final CapsulePart part, EObject source, MultiStatus result) {
        Functions.Function1<CapsulePart, Boolean> _function;
        Iterable allParentParts;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)part);
        Capsule capsule = (Capsule)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Capsule && (_exists = IterableExtensions.exists((Iterable)(allParentParts = XTUMLRTExtensions.getAllCapsuleParts((Capsule)((Capsule)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return Objects.equal((Object)it.getName(), (Object)part.getName()) && part.getRedefines() != it;
            }
        })))) {
            StatusFactory.addErrorStatus(source, "Port has the same name as a port in the parent capsule but it does not redefine it.", "A named element that redefines another named element must have the same name.", result);
        }
    }

    protected void _validateElement(final Connector conn, EObject source, MultiStatus result) {
        Functions.Function1<Connector, Boolean> _function;
        Iterable allParentParts;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)conn);
        Capsule capsule = (Capsule)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Capsule && (_exists = IterableExtensions.exists((Iterable)(allParentParts = XTUMLRTExtensions.getAllConnectors((Capsule)((Capsule)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<Connector, Boolean>(){

            public Boolean apply(Connector it) {
                return Objects.equal((Object)it.getName(), (Object)conn.getName()) && conn.getRedefines() != it;
            }
        })))) {
            StatusFactory.addErrorStatus(source, "Connector has the same name as a connector in the parent capsule but it does not redefine it", "A named element that redefines another named element must have the same name.", result);
        }
    }

    protected void _validateElement(final Attribute attr, EObject source, MultiStatus result) {
        Functions.Function1<Attribute, Boolean> _function;
        Iterable allParentAttrs;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)attr);
        Entity capsule = (Entity)_owner;
        RedefinableElement capsuleParent = capsule.getRedefines();
        if (capsuleParent instanceof Entity && (_exists = IterableExtensions.exists((Iterable)(allParentAttrs = XTUMLRTExtensions.getAllAttributes((StructuredType)((StructuredType)capsuleParent))), (Functions.Function1)(_function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return Objects.equal((Object)it.getName(), (Object)attr.getName()) && attr.getRedefines() != it;
            }
        })))) {
            StatusFactory.addErrorStatus(source, "Attribute has the same name as a attribute in the parent capsule but it does not redefine it", "A named element that redefines another named element must have the same name.", result);
        }
    }

    protected void _validateElement(final Signal signal, EObject source, MultiStatus result) {
        Functions.Function1<Signal, Boolean> _function;
        Iterable allParentSignals;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)signal);
        Protocol protocol = (Protocol)_owner;
        RedefinableElement protocolParent = protocol.getRedefines();
        if (protocolParent instanceof Protocol && (_exists = IterableExtensions.exists((Iterable)(allParentSignals = XTUMLRTExtensions.getAllSignals((Protocol)((Protocol)protocolParent))), (Functions.Function1)(_function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return Objects.equal((Object)it.getName(), (Object)signal.getName()) && signal.getRedefines() != it;
            }
        })))) {
            StatusFactory.addErrorStatus(source, "Protocol message has the same name as a protocol message in the parent protocol but it does not redefine it", "A named element that redefines another named element must have the same name.", result);
        }
    }

    protected void _validateElement(final State state, EObject source, MultiStatus result) {
        Functions.Function1<State, Boolean> _function;
        EList allParentStates;
        boolean _exists;
        NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)state);
        RedefinableElement owner = (RedefinableElement)_owner;
        if (owner instanceof StateMachine) {
            return;
        }
        RedefinableElement redefine = owner.getRedefines();
        if (redefine instanceof CompositeState && (_exists = IterableExtensions.exists((Iterable)(allParentStates = ((CompositeState)redefine).getSubstates()), (Functions.Function1)(_function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return Objects.equal((Object)it.getName(), (Object)state.getName()) && state.getRedefines() != it;
            }
        })))) {
            StatusFactory.addErrorStatus(source, "State has the same name as a state in the parent state but it does not redefine it", "A named element that redefines another named element must have the same name.", result);
        }
    }

    protected void validateElement(EObject attr, EObject source, MultiStatus result) {
        if (attr instanceof Attribute) {
            this._validateElement((Attribute)attr, source, result);
            return;
        }
        if (attr instanceof CapsulePart) {
            this._validateElement((CapsulePart)attr, source, result);
            return;
        }
        if (attr instanceof Connector) {
            this._validateElement((Connector)attr, source, result);
            return;
        }
        if (attr instanceof Port) {
            this._validateElement((Port)attr, source, result);
            return;
        }
        if (attr instanceof Signal) {
            this._validateElement((Signal)attr, source, result);
            return;
        }
        if (attr instanceof State) {
            this._validateElement((State)attr, source, result);
            return;
        }
        if (attr instanceof Transition) {
            this._validateElement((Transition)attr, source, result);
            return;
        }
        if (attr != null) {
            this._validateElement(attr, source, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(attr, source, result).toString());
    }
}

