/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.UserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.IReferencable;

public class FunctionPointer
extends UserElement
implements IReferencable {
    private final Type returnType;
    private final List<Type> parameters = new ArrayList<Type>();

    public FunctionPointer(Type returnType) {
        this.returnType = returnType;
    }

    public void add(Type param) {
        this.parameters.add(param);
    }

    public boolean write(CppFormatter fmt) {
        if (!(this.returnType.write(fmt, null) && fmt.space() && fmt.write("(*)("))) {
            return false;
        }
        boolean first = true;
        for (Type param : this.parameters) {
            if (first) {
                first = false;
            } else if (!fmt.write(", ")) {
                return false;
            }
            if (param.write(fmt, null)) continue;
            return false;
        }
        return fmt.write(')');
    }

    @Override
    public boolean write(CppFormatter fmt, Name name, List<Type.Pointer> pointerSpec, List<Expression> arrayBounds) {
        if (!(this.returnType.write(fmt, null) && fmt.space() && fmt.write('(') && fmt.write('*'))) {
            return false;
        }
        for (Type.Pointer ptr : pointerSpec) {
            if (ptr.write(fmt)) continue;
            return false;
        }
        if (!fmt.write(name)) {
            return false;
        }
        for (Expression bound : arrayBounds) {
            if (fmt.write('[') && (bound == null || bound.write(fmt)) && fmt.write(']')) continue;
            return false;
        }
        if (!fmt.write(')') || !fmt.write('(')) {
            return false;
        }
        boolean first = true;
        for (Type param : this.parameters) {
            if (first) {
                first = false;
            } else if (!fmt.write(", ")) {
                return false;
            }
            if (param.write(fmt, null)) continue;
            return false;
        }
        return fmt.write(')');
    }
}

