/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.Literal;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class IntegralLiteral
extends Literal {
    private final String suffix;

    public IntegralLiteral(int value) {
        this(Integer.toString(value));
    }

    public IntegralLiteral(String value) {
        this(PrimitiveType.INT, value);
    }

    private IntegralLiteral(PrimitiveType intType, String value) {
        super(intType, value);
        if (!intType.isIntegral()) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(intType)) + " is not a basic integral literal type");
        }
        this.suffix = intType.isUnsigned() ? "u" : "";
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return super.write(fmt) && fmt.write(this.suffix);
    }
}

