/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.cdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrusrt.codegen.IEObjectLocator;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTOpaqueBehavior;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.xtumlrt.util.NamesUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;

public class UMLEObjectLocator
implements IEObjectLocator {
    public static final String LANGUAGE = "C++";
    private ModelSet rset = null;
    private Map<String, ModelSet> modelSetMap = new HashMap<String, ModelSet>();

    private Package getRoot(String uri) {
        URI resourceUri = URI.createURI((String)uri);
        if (this.modelSetMap.containsKey(uri)) {
            this.rset = this.modelSetMap.get(uri);
        } else if (this.rset == null) {
            try {
                ExtensionServicesRegistry registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
                registry.startServicesByClassKeys(new java.lang.Class[]{ModelSet.class});
                this.rset = (ModelSet)registry.getService(ModelSet.class);
                try {
                    registry.startRegistry();
                }
                catch (ServiceException serviceException) {}
                this.rset.loadModels(resourceUri);
            }
            catch (ModelMultiException | ServiceException throwable) {}
        }
        UmlModel model = (UmlModel)this.rset.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        Package root = null;
        try {
            root = (Package)model.lookupRoot();
        }
        catch (NotFoundException notFoundException) {}
        return root;
    }

    public EObject getEObject(UserEditableRegion.Label label) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.addAll(Arrays.asList(label.getQualifiedName().split("::")));
        Package nextPackage = this.getRoot(label.getUri());
        if (nextPackage == null) {
            return null;
        }
        Class capsuleOrClass = null;
        qualifiedNames.remove(0);
        while (!qualifiedNames.isEmpty()) {
            String qname = (String)qualifiedNames.remove(0);
            Package pkg = nextPackage.getNestedPackage(qname);
            if (pkg == null) {
                capsuleOrClass = (Class)nextPackage.getPackagedElement(qname, false, UMLPackage.Literals.CLASS, false);
                break;
            }
            nextPackage = pkg;
        }
        EObject result = null;
        if (capsuleOrClass != null) {
            if (label.getType().equals(UMLPackage.Literals.OPERATION.getName().toLowerCase())) {
                final Class clazz = capsuleOrClass;
                final Operation op = capsuleOrClass.getOwnedOperation(label.getDetails(), null, null);
                if (op != null) {
                    OpaqueBehavior method;
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)capsuleOrClass);
                    if (op.getMethods().isEmpty()) {
                        RecordingCommand cmd = new RecordingCommand(domain){

                            protected void doExecute() {
                                OpaqueBehavior method = (OpaqueBehavior)clazz.createOwnedBehavior(null, UMLPackage.Literals.OPAQUE_BEHAVIOR);
                                op.getMethods().add((Object)method);
                                method.getLanguages().add((Object)UMLEObjectLocator.LANGUAGE);
                                method.getBodies().add((Object)"");
                            }
                        };
                        domain.getCommandStack().execute((Command)cmd);
                    }
                    if (!(method = (OpaqueBehavior)op.getMethods().get(0)).getLanguages().contains((Object)LANGUAGE)) {
                        RecordingCommand cmd = new RecordingCommand(domain){

                            protected void doExecute() {
                                method.getLanguages().add((Object)UMLEObjectLocator.LANGUAGE);
                                method.getBodies().add((Object)"");
                            }
                        };
                        domain.getCommandStack().execute((Command)cmd);
                    }
                    result = method;
                }
            } else {
                EObject smElement = this.getSMElement(capsuleOrClass, qualifiedNames);
                result = this.getUserCodeElement(smElement, label.getType(), label.getDetails());
            }
        }
        return result;
    }

    private EObject getUserCodeElement(EObject container, String type, String details) {
        UMLRTTrigger rtTrigger;
        UserEditableRegion.TriggerDetail tdetail;
        Trigger trigger;
        String[] tokens;
        Transition transition;
        Behavior result = null;
        if (type.equals(UMLPackage.Literals.TRANSITION.getName().toLowerCase())) {
            Transition t = this.getTransition(container, details);
            if (t != null) {
                result = t.getEffect();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__ENTRY.getName())) {
            if (container instanceof State) {
                UMLRTState state = UMLRTState.getInstance((State)((State)container));
                if (state != null) {
                    result = state.getEntry().toUML();
                } else {
                    State s = (State)container;
                    result = s.getEntry();
                }
            }
        } else if (type.equals(UMLPackage.Literals.STATE__EXIT.getName())) {
            if (container instanceof State) {
                UMLRTState state = UMLRTState.getInstance((State)((State)container));
                if (state != null) {
                    result = state.getExit().toUML();
                } else {
                    State s = (State)container;
                    result = s.getExit();
                }
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__GUARD.getName())) {
            Transition t = this.getTransition(container, details);
            if (t != null) {
                UMLRTTransition rtTransition = UMLRTTransition.getInstance((Transition)t);
                result = rtTransition != null && rtTransition.getGuard() != null ? rtTransition.getGuard().toUML() : t.getGuard();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__TRIGGER.getName()) && (transition = this.getTransition(container, (tokens = details.split(">>"))[0])) != null && (trigger = this.findTrigger(transition, tdetail = new UserEditableRegion.TriggerDetail(tokens[1]))) != null && (rtTrigger = UMLRTTrigger.getInstance((Trigger)trigger)).getGuard() != null) {
            result = rtTrigger.getGuard().toUML();
        }
        return result;
    }

    private EObject getSMElement(Class capsule, List<String> qnameRelativeToSM) {
        UMLRTCapsule rtCapsule = UMLRTCapsule.getInstance((Class)capsule);
        StateMachine result = null;
        if (rtCapsule != null) {
            UMLRTStateMachine sm = rtCapsule.getStateMachine();
            UMLRTState state = null;
            if (!qnameRelativeToSM.isEmpty()) {
                state = (UMLRTState)sm.getVertex(qnameRelativeToSM.remove(0), false, UMLRTUMLRTPackage.Literals.STATE);
                while (state != null && !qnameRelativeToSM.isEmpty()) {
                    state = (UMLRTState)state.getSubvertex(qnameRelativeToSM.remove(0), false, UMLRTUMLRTPackage.Literals.STATE);
                }
                result = !qnameRelativeToSM.isEmpty() ? null : (state == null ? null : state.toUML());
            } else {
                result = sm.toUML();
            }
        }
        return result;
    }

    private Transition getTransition(EObject container, String transitionDetails) {
        Transition result = null;
        List transitions = new ArrayList();
        if (container instanceof StateMachine) {
            UMLRTStateMachine sm = UMLRTStateMachine.getInstance((StateMachine)((StateMachine)container));
            transitions = sm.getTransitions();
        } else {
            UMLRTState state = UMLRTState.getInstance((State)((State)container));
            transitions = state.getSubtransitions();
        }
        UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(transitionDetails);
        for (UMLRTTransition t : transitions) {
            if (!UMLEObjectLocator.getSMQualifiedName((EObject)t.toUML().getSource()).equals(details.getSourceQname()) || !UMLEObjectLocator.getSMQualifiedName((EObject)t.toUML().getTarget()).equals(details.getTargetQname())) continue;
            if (details.getTriggerDetails().isEmpty()) {
                result = t.toUML();
                break;
            }
            if (details.getTriggerDetails().size() != t.getTriggers().size()) continue;
            Trigger trigger = null;
            for (UserEditableRegion.TriggerDetail detail : details.getTriggerDetails()) {
                trigger = this.findTrigger(t.toUML(), detail);
                if (trigger == null) break;
            }
            if (trigger == null) continue;
            result = t.toUML();
            break;
        }
        return result;
    }

    private Trigger findTrigger(Transition transition, UserEditableRegion.TriggerDetail detail) {
        Trigger result = null;
        UMLRTTransition rtTransition = UMLRTTransition.getInstance((Transition)transition);
        Object triggers = new ArrayList();
        triggers = rtTransition != null ? rtTransition.getTriggers().stream().map(t -> t.toUML()).collect(Collectors.toList()) : transition.getTriggers();
        for (Trigger trigger : triggers) {
            Event event = trigger.getEvent();
            if (event == null || !(event instanceof CallEvent) && !(event instanceof AnyReceiveEvent)) continue;
            String signalName = "*";
            if (event instanceof CallEvent) {
                Operation message = ((CallEvent)event).getOperation();
                signalName = message.getName();
            }
            if (!detail.getSignal().equals(signalName) || !this.comparetriggerPorts((List<Port>)trigger.getPorts(), detail.getPorts())) continue;
            result = trigger;
            break;
        }
        return result;
    }

    private boolean comparetriggerPorts(List<Port> ports, List<String> expectedPorts) {
        ArrayList<String> actualPorts = new ArrayList<String>();
        for (Port p : ports) {
            actualPorts.add(p.getName());
        }
        actualPorts.retainAll(expectedPorts);
        return actualPorts.size() == expectedPorts.size();
    }

    public static String getSMQualifiedName(EObject eObject) {
        String result = "";
        EObject container = eObject;
        while (container != null && !(container instanceof StateMachine)) {
            if (container instanceof Vertex) {
                if (result.length() != 0) {
                    result = "::" + result;
                }
                result = String.valueOf(NamesUtil.getEffectiveName((EObject)container)) + result;
            }
            container = container.eContainer();
        }
        return result;
    }

    public UserEditableRegion.CommitResult saveSource(UserEditableRegion.Label label, String source) {
        Constraint guard;
        ValueSpecification value;
        EObject eo = this.getEObject(label);
        UserEditableRegion.CommitResult result = null;
        if (eo instanceof OpaqueBehavior) {
            result = this.saveOpaqueBehaviour(eo, (OpaqueBehavior)eo, source);
        } else if (eo instanceof Constraint && (value = (guard = (Constraint)eo).getSpecification()) instanceof OpaqueExpression) {
            result = this.saveOpaqueExpression(eo, (OpaqueExpression)value, source);
        }
        if (result == null) {
            result = new UserEditableRegion.CommitResult(eo, null, false);
        }
        return result;
    }

    private String trimSource(String source) {
        String pattern = "\\r *|\\n *|\\t";
        String replaceString = "";
        return source.trim().replaceAll(pattern, replaceString);
    }

    private UserEditableRegion.CommitResult saveOpaqueExpression(EObject context, final OpaqueExpression oe, final String source) {
        boolean shouldUpdate = false;
        final int bodyIndex = oe.getLanguages().indexOf((Object)LANGUAGE);
        if (!oe.getBodies().isEmpty()) {
            String body = (String)oe.getBodies().get(0);
            if (!this.trimSource(source).equals(this.trimSource(body))) {
                shouldUpdate = true;
            }
        } else {
            shouldUpdate = true;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)oe);
        RecordingCommand command = null;
        if (shouldUpdate) {
            command = new RecordingCommand(domain){

                protected void doExecute() {
                    if (bodyIndex != -1) {
                        oe.getBodies().remove(bodyIndex);
                        oe.getBodies().add(bodyIndex, (Object)source);
                    } else {
                        oe.getLanguages().add((Object)UMLEObjectLocator.LANGUAGE);
                        oe.getBodies().add((Object)source);
                    }
                }
            };
        }
        return new UserEditableRegion.CommitResult(context, command, command != null && !this.modelSetMap.containsKey(this.rset));
    }

    private UserEditableRegion.CommitResult saveOpaqueBehaviour(EObject context, final OpaqueBehavior ob, final String source) {
        boolean shouldUpdate = true;
        RecordingCommand command = null;
        int index = ob.getLanguages().indexOf((Object)LANGUAGE);
        if (index >= 0 && ob.getBodies().size() > index) {
            String body = (String)ob.getBodies().get(index);
            if (this.trimSource(source).equals(this.trimSource(body))) {
                shouldUpdate = false;
            }
        }
        if (shouldUpdate) {
            Runnable runnable;
            final AtomicReference<4> reference = new AtomicReference<4>();
            final UMLRTOpaqueBehavior rtOb = UMLRTOpaqueBehavior.getInstance((OpaqueBehavior)ob);
            if (rtOb != null) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        rtOb.getBodies().put(UMLEObjectLocator.LANGUAGE, source);
                    }
                };
                reference.set(runnable);
            } else {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        int bodyIndex = ob.getLanguages().indexOf((Object)UMLEObjectLocator.LANGUAGE);
                        if (bodyIndex == -1) {
                            ob.getLanguages().add((Object)UMLEObjectLocator.LANGUAGE);
                            bodyIndex = ob.getLanguages().size() - 1;
                        }
                        int numFillBody = ob.getLanguages().size() - ob.getBodies().size();
                        while (numFillBody-- > 0) {
                            ob.getBodies().add((Object)"");
                        }
                        ob.getBodies().set(bodyIndex, (Object)source);
                    }
                };
                reference.set(runnable);
            }
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ob);
            command = new RecordingCommand(domain){

                protected void doExecute() {
                    ((Runnable)reference.get()).run();
                }
            };
        }
        return new UserEditableRegion.CommitResult(context, command, command != null && !this.modelSetMap.containsValue(this.rset));
    }

    public void initialize() {
        ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>();
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference editor = iEditorReferenceArray[n6];
                        IEditorPart part = editor.getEditor(false);
                        if (part instanceof PapyrusMultiDiagramEditor) {
                            editors.add(editor);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        for (IEditorReference ref : editors) {
            PapyrusMultiDiagramEditor editor = (PapyrusMultiDiagramEditor)ref.getEditor(false);
            ServicesRegistry reg = editor.getServicesRegistry();
            try {
                ModelSet modelSet = (ModelSet)reg.getService(ModelSet.class);
                UmlModel model = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                this.modelSetMap.put(model.getResourceURI().toString(), modelSet);
            }
            catch (ServiceException serviceException) {}
        }
    }

    public void cleanUp() {
        if (this.rset != null && !this.modelSetMap.containsValue(this.rset)) {
            this.rset.unload();
        }
        this.rset = null;
        this.modelSetMap.clear();
    }
}

