/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.EObjectLocator;
import org.eclipse.papyrusrt.codegen.ICodeLocator;
import org.eclipse.uml2.common.util.UML2Util;

public class UserEditableRegion {
    public static final String USER_REGION_TAG = "UMLRTGEN-USERREGION-";
    public static final String USER_EDIT_BEGIN_TAG = "BEGIN";
    public static final String USER_EDIT_END_TAG = "END";
    public static final String COMMENT_START_STRING = "/* ";
    public static final String COMMENT_END_STRING = " */";
    public static final String USER_EDIT_MARKER = "UMLRTGEN-USERREGION-BEGIN";
    public static final Locator LOCATOR = new Locator();
    public static final String SEPARATOR = "::";
    private static final String EMPTY = new String();
    private final String userRegionTag;
    private final int line;
    private final StringBuilder userText = new StringBuilder();

    public UserEditableRegion(String tag, int line) {
        this.userRegionTag = tag;
        this.line = line;
    }

    public String getUserRegionTag() {
        return this.userRegionTag;
    }

    public int getLine() {
        return this.line;
    }

    public StringBuilder getUserText() {
        return this.userText;
    }

    public static String userEditBegin(Label label) {
        return UserEditableRegion.getIdentifyingString(label.uri, label.qualifiedName, label.type, label.details);
    }

    public static String getIdentifyingString(String uriString, String qname, String type, String details) {
        if (UML2Util.isEmpty((String)uriString)) {
            return "";
        }
        if (qname == null || qname.isEmpty() || type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Valid strings required for all identifying attributes");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(USER_REGION_TAG);
        sb.append(USER_EDIT_BEGIN_TAG);
        sb.append(' ');
        sb.append(uriString == null ? EMPTY : uriString);
        sb.append(' ');
        sb.append(qname == null ? EMPTY : qname);
        sb.append(' ');
        sb.append(type == null ? EMPTY : type);
        sb.append(' ');
        sb.append(details == null ? EMPTY : details);
        return sb.toString();
    }

    private static Label parseLabel(String idString) {
        Label label = new Label();
        StringTokenizer tokenizer = new StringTokenizer(idString);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        label.uri = tokenizer.nextToken();
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        label.qualifiedName = tokenizer.nextToken();
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        label.type = tokenizer.nextToken();
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        label.details = tokenizer.nextToken("$").replaceAll("\\*/", "").trim();
        return label;
    }

    public static EObject getEObject(Label label) {
        return EObjectLocator.getInstance().getEObject(label);
    }

    public static String userEditEnd() {
        return "UMLRTGEN-USERREGION-END";
    }

    public CommitResult commit() {
        Label l = UserEditableRegion.parseLabel(this.userRegionTag);
        CommitResult result = EObjectLocator.getInstance().saveSource(l, this.userText.toString());
        result.setUri(this.userRegionTag);
        return result;
    }

    public static boolean containsUserEditableRegions(CharSequence buffer) {
        return buffer.toString().contains(USER_EDIT_MARKER);
    }

    /*
     * Exception decompiling
     */
    public static boolean containsUserEditableRegions(InputStream in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class CommitResult {
        private EObject target;
        private String uri;
        private boolean shouldSave;
        private Command command = null;

        public CommitResult(EObject target, Command command, boolean shouldSave) {
            this.target = target;
            this.command = command;
            this.shouldSave = shouldSave;
        }

        public boolean shouldSave() {
            return this.shouldSave;
        }

        public void setShouldSave(boolean shouldSave) {
            this.shouldSave = shouldSave;
        }

        public EObject getTarget() {
            return this.target;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public Command getCommand() {
            return this.command;
        }

        public void setCommand(Command command) {
            this.command = command;
        }
    }

    public static class Label {
        private String uri;
        private String qualifiedName;
        private String type;
        private String details;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public void setQualifiedName(String parentQualifiedName) {
            this.qualifiedName = parentQualifiedName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }

    public static class Locator
    implements ICodeLocator {
        @Override
        public int getLineNumber(IFile file, Label label) {
            LineNumberReader reader = null;
            try {
                reader = new LineNumberReader(new InputStreamReader(file.getContents()));
            }
            catch (CoreException coreException) {
                return -1;
            }
            String id = UserEditableRegion.getIdentifyingString(label.getUri(), label.getQualifiedName(), label.getType(), label.getDetails());
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(id)) continue;
                    return reader.getLineNumber();
                }
            }
            catch (IOException iOException) {}
            return -1;
        }
    }

    public static class TransitionDetails {
        public static final String DETAIL_SEPARATOR = ",";
        public static final String TRIGGER_SEPARATOR = "/";
        public static final String EXTRA_DETAIL_SEPARATOR = ">>";
        private String sourceQname;
        private String targetQname;
        private List<TriggerDetail> triggerDetails = new ArrayList<TriggerDetail>();

        public TransitionDetails(String details) {
            String[] d1 = details.split(DETAIL_SEPARATOR);
            this.sourceQname = d1[0];
            this.targetQname = "";
            if (d1.length > 1) {
                this.targetQname = d1[1];
            }
            if (d1.length > 2) {
                String[] d2;
                String[] stringArray = d2 = d1[2].split(TRIGGER_SEPARATOR);
                int n = d2.length;
                int n2 = 0;
                while (n2 < n) {
                    String triggerDetail = stringArray[n2];
                    this.triggerDetails.add(new TriggerDetail(triggerDetail));
                    ++n2;
                }
            }
        }

        public TransitionDetails(String sourceQname, String targetQname) {
            this.sourceQname = sourceQname;
            this.targetQname = targetQname;
        }

        public String getSourceQname() {
            return this.sourceQname;
        }

        public String getTargetQname() {
            return this.targetQname;
        }

        public List<TriggerDetail> getTriggerDetails() {
            return this.triggerDetails;
        }

        public void addTriggerDetail(String signal, List<String> ports) {
            this.addTriggerDetail(new TriggerDetail(signal, ports));
        }

        public void addTriggerDetail(TriggerDetail detail) {
            this.triggerDetails.add(detail);
        }

        public String getTagString() {
            StringBuilder result = new StringBuilder();
            result.append(this.sourceQname).append(DETAIL_SEPARATOR).append(this.targetQname).append(DETAIL_SEPARATOR);
            for (TriggerDetail triggerDetail : this.triggerDetails) {
                result.append(triggerDetail.getTagString());
                result.append(TRIGGER_SEPARATOR);
            }
            String resultString = result.toString();
            if (resultString.endsWith(TRIGGER_SEPARATOR) || resultString.endsWith(DETAIL_SEPARATOR)) {
                return resultString.substring(0, resultString.length() - 1);
            }
            return resultString;
        }
    }

    public static class TriggerDetail {
        public static final String DETAIL_SEPARATOR = ":";
        private String signal;
        private List<String> ports;

        public TriggerDetail(String signal, List<String> ports) {
            this.signal = signal;
            this.ports = ports;
        }

        public TriggerDetail(String detail) {
            String[] d3 = detail.split(DETAIL_SEPARATOR);
            this.signal = d3[0];
            this.ports = new ArrayList<String>();
            int i = 1;
            while (i < d3.length) {
                this.ports.add(d3[i]);
                ++i;
            }
        }

        public String getSignal() {
            return this.signal;
        }

        public List<String> getPorts() {
            return this.ports;
        }

        public String getTagString() {
            StringBuilder result = new StringBuilder();
            result.append(this.signal);
            for (String p : this.ports) {
                result.append(DETAIL_SEPARATOR).append(p);
            }
            return result.toString();
        }
    }
}

