/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.ui.internal.diagram;

import com.google.common.base.Predicate;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;

public class UMLRTAutomaticDiagramChangesFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            if (input instanceof TreeNode) {
                TreeNode node = (TreeNode)input;
                EObject data = node.getData();
                return UMLRTCompareUtil.isAutoDiagramChange((EObject)data);
            }
            return false;
        }
    };

    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }

    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        if (scope != null) {
            for (String nsURI : scope.getNsURIs()) {
                if (!nsURI.matches("http://www\\.eclipse\\.org/papyrus.*/umlrt")) continue;
                return true;
            }
        }
        return false;
    }
}

