/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.ui.internal.differenceGroup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.tree.TreeNode;

public abstract class AbstractFilteringGroupExtender
implements IDifferenceGroupExtender {
    public void addChildren(TreeNode treeNode) {
        ComposedAdapterFactory adapterFactory = this.getAdapterFactory(treeNode);
        ImmutableList.Builder collectedGrandChildren = ImmutableList.builder();
        Iterator iterator = treeNode.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode childTreeNode = (TreeNode)iterator.next();
            if (!this.shouldFilter(childTreeNode, (AdapterFactory)adapterFactory)) continue;
            collectedGrandChildren.addAll((Iterable)childTreeNode.getChildren());
            iterator.remove();
        }
        treeNode.getChildren().addAll((Collection)collectedGrandChildren.build());
        if (IDisposable.class.isInstance(adapterFactory)) {
            ((IDisposable)IDisposable.class.cast(adapterFactory)).dispose();
        }
    }

    protected abstract boolean shouldFilter(TreeNode var1, AdapterFactory var2);

    protected ComposedAdapterFactory getAdapterFactory(TreeNode treeNode) {
        Map<Object, Object> context = this.createAdapterFactoryContext(treeNode);
        return new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry(context));
    }

    protected Map<Object, Object> createAdapterFactoryContext(TreeNode treeNode) {
        Comparison comparison = this.getComparison(treeNode);
        LinkedHashMap context = comparison != null ? ImmutableMap.of((Object)"comparison", (Object)comparison) : Maps.newLinkedHashMap();
        return context;
    }

    private Comparison getComparison(TreeNode treeNode) {
        EObject eObject = treeNode.getData();
        Match match = this.getMatch(eObject);
        Comparison comparison = match != null ? match.getComparison() : null;
        return comparison;
    }

    private Match getMatch(EObject eObject) {
        Object match = Diff.class.isInstance(eObject) ? ((Diff)Diff.class.cast(eObject)).getMatch() : (Match.class.isInstance(eObject) ? (Match)Match.class.cast(eObject) : null);
        return match;
    }
}

